function slicedata=disassemble_timeseries_to_slices(data,zdim,tdim,TR,TE,slice_mode)
%function slicedata=disassemble_timeseries_to_slices(data,zdim,tdim,TR,TE,slice_mode)
% this function takes in timeseries of data, assumes it has an evenly-spaced
% timing mesh, and separates out slices of data that have the same timing
% as the acquired data (i.e. the slices may not be evenly spaced in time)
% the purpose of this script is to take physiologic timeseries that have been 
% filtered, converted to phase and otherwise massaged, and produce data specific
% to the MRI data

zdim=double(zdim);
data=double(data);
tdim=double(tdim);
if (exist('TR')==0)
  % most common TR, however, a guess is worse than actually inputting the correct value
  TR=2000;
end
if (exist('TE')==0)
  % if GRE 3T, this is a good guess, otherwise actual TE is likely to be higher
  TE=29;
end
TR=double(TR);
TE=double(TE);
if (exist('slice_mode')==0)
  slice_mode='siemens-alt-asc';
end
if (TR<30)
  % assume TR has been given in seconds, rather than milliseconds, adjust
  TR=TR*1000;
  if (isnumeric(slice_mode))
    slice_mode=slice_mode*1000;
  end
end
[acquisition_timing,slice_timing]=get_slice_timing(slice_mode,zdim,TR,TE);
sorted_slice_timing=sort(slice_timing);

% for disassembling, interpolate _to_ the slice acquisition timing
% since we're assuming we got full length data from parallel measures
for i=1:tdim
  outputmesh(((i-1)*zdim)+1:(i*zdim))=((i-1)*TR)+acquisition_timing;
end
% interpolate from evenly spaced mesh, starting at zeropoint of acquisition timing
% we do this because we don't really gain anything by shifting to volume acquisition
% and then back again, but we potentially lose alot by interpolating the startpoint to infinity
inputmesh=linspace(acquisition_timing(1),TR*tdim-(TR/zdim)+acquisition_timing(1),length(data));
if (size(data,2)>size(data,1))
  data=data';
end

% interpolate and tie endpoints
data=pchip([(2*inputmesh(1)-inputmesh(2)) inputmesh (2*inputmesh(end)-inputmesh(end-1))],[data(1); data; data(end)],[(2*outputmesh(1)-outputmesh(2)) outputmesh (2*outputmesh(end)-outputmesh(end-1))]);
data=data(2:end-1);

for z=1:zdim
  % slice_index tells us which slice is chronologically acquired as z increases
  slice_index=find(slice_timing==sorted_slice_timing(z));
  slicedata(slice_index,:)=data(z:zdim:zdim*tdim-zdim+z);
end

