#! /bin/bash

zdim=$1
TR=$2
if [ -z $zdim -o -z $TR ] ; then
  echo "pass number of slices and TR (msec) to script"
  echo "Usage example: ./filter_pestica_est.sh 31 2800"
  exit
fi
echo "filter is assuming we have $zdim slices, with TR=$TR in EPI data"

 # PESTICA coreg to template
 echo "Filtering PESTICA estimators, cardiac first, then respiratory"
 echo  matlab -nojvm -nosplash -r "addpath $PESTICA_DIR; load('card_rawest.dat'); load('resp_rawest.dat'); card=view_and_correct_estimator(card_rawest,$zdim,$TR); resp=view_and_correct_estimator(resp_rawest,$zdim,$TR); fp=fopen('card_pestica.dat','w'); fprintf(fp,'%g\n',card); fclose(fp); fp=fopen('resp_pestica.dat','w'); fprintf(fp,'%g\n',resp); fclose(fp); exit;"
       matlab -nojvm -nosplash -r "addpath $PESTICA_DIR; load('card_rawest.dat'); load('resp_rawest.dat'); card=view_and_correct_estimator(card_rawest,$zdim,$TR); resp=view_and_correct_estimator(resp_rawest,$zdim,$TR); fp=fopen('card_pestica.dat','w'); fprintf(fp,'%g\n',card); fclose(fp); fp=fopen('resp_pestica.dat','w'); fprintf(fp,'%g\n',resp); fclose(fp); exit;"


