#! /bin/bash

epi=$1
slice_timing="siemens-alt-asc"
echo "using $slice_timing for slice timing - correct this in script if wrong"
# test if NIFTI_GZ format
a=`echo $epi | grep gz`
if [ ! -z $a ] ; then
  gunzip $epi
  epi=`echo $epi | sed "s/.gz//"`
fi
b=`echo $epi | grep nii`
if [ ! -z $b ] ; then
  epi=`echo $epi | sed "s/.nii//"`
  suffix=".nii"
  fsuffix=".nii"
fi
c=`echo $epi | grep "+orig"`
if [ ! -z $c ] ; then
  epi=`echo $epi | sed "s/+orig//"`
  suffix="+orig"
  fsuffix="+orig.BRIK"
fi

if [ -z $epi ] ; then
  echo "Usage example: ./make_physio_qa.sh ep2d_pace_132vols"
  exit
fi
# test for presence of both files
if [ ! -f $epi$fsuffix ] ; then
  echo "*****   $epi$fsuffix does not exist"
  echo "Usage example: ./make_physio_qa.sh ep2d_pace_132vols"
  echo "Files must be in NIFTI or AFNI BRIK format"
  exit
fi

epi=$epi$suffix

 # make histogram of physio periodicity (approx heart rate, breathing rate)
 # number of voxels sign coupled to cardiac/respiration
 # stddev pre and post physio corr

 echo "matlab  -nojvm -nosplash -r addpath $PESTICA_DIR; addpath $PESTICA_DIR/matlab_retroicor; physio_qa(); exit;"
       matlab  -nojvm -nosplash -r "addpath $PESTICA_DIR; addpath $PESTICA_DIR/matlab_retroicor; physio_qa(); exit;"

if [ ! -z $a ] ; then
  gzip $epi
fi

