function fix_physio_peaks(card,cardph,f_s,physio_type)
% function fix_physio_peaks(card,cardph,f_s)
% requires cardiac data and first pass phase data, f_s=cardiac sampling frequency.
% takes cardiac physio input and looks for missing or extra peaks,
% then after these are labelled, it produces a new phase vector and stores it
% in physio.mat as new cardiac and phase vectors.
global seg yl nseg maxseg c cp minp min_period cp_newpeaks cp_extrapeaks avg_period f_s h

if (exist('physio_type')==0)
  physio_type='card';
end

c=card;
c=(c-mean(c))/std(c);
[peak_indices,avg_period,new_phasedata,midpoint_phasedata,midpoints]=get_phase_period(cardph,physio_type);
cp=0*c;
if (peak_indices(1)==1)
  peak_indices=peak_indices(2:end);
end
if (peak_indices(end)==length(c))
  peak_indices=peak_indices(1:end-1);
end
cp(peak_indices)=1;
cp_newpeaks=0*cp;
cp_extrapeaks=0*cp;

% get minimum periodicity in both units of indices and seconds
minp=min(peak_indices(2:end)-peak_indices(1:end-1));
min_period=minp/f_s;

h=figure;
set(h,'Menubar','none');
plot(linspace(1/f_s,length(c)/f_s,length(c)),c);
hold on
plot(linspace(1/f_s,length(c)/f_s,length(c)),cp_newpeaks,'r','linewidth',2);
plot(linspace(1/f_s,length(c)/f_s,length(c)),cp,'k','linewidth',2);
hold off

% loop over segments in units of 20 seconds, allowing user to click on extra or missing peaks
seg=1;
nseg=ceil((length(c)/f_s)/20);
maxseg=(length(c)/f_s);
xlim([20*(seg-1) 20*seg]);
ylim([min(c) max(c)]);
yl=ylim;
% register callbacks
hpop_last = uicontrol('Style','pushbutton','String','Last Segment','Position',[20 5 100 25],'Callback','last_xlim');
hpop_next = uicontrol('Style','pushbutton','String','Next Segment','Position',[120 5 100 25],'Callback','next_xlim');
hpop_missing = uicontrol('Style','pushbutton','String','Found Missing','Position',[220 5 100 25],'Callback','peak_missing');
hpop_extra = uicontrol('Style','pushbutton','String','Found Extra','Position',[320 5 100 25],'Callback','peak_extra');
hpop_data = uicontrol('Style','pushbutton','String','Write Data','Position',[420 5 100 25],'Callback','write_data');

