function secondordermoco(ep2d_filename,motionfile,mask_filename)
% MUST use the output of AFNI 3dvolreg text file such as:
%   3dvolreg -verbose -dfile motion.txt -heptic epi+orig
% where in this example we would use motionfile='motion.txt';
% 3dvolreg motion file contains 9 columns:
%   Repetition	I-Srot	R-Lrot	A-Prot	S	L	P	RMSold	RMSnew
%   coordinates	  Z	  X	  Y	z	x	y
% and where rotations are in degrees

ainfo=analyze75info(ep2d_filename);
xdim=ainfo.Dimensions(1);
ydim=ainfo.Dimensions(2);
zdim=ainfo.Dimensions(3);
tdim=ainfo.Dimensions(4);
ima=analyze75read(ep2d_filename);
if (exist('mask_filename')==0)
  mask_filename='';
end
if (exist(mask_filename)<2)
  ima_mask=analyze75read(mask_filename);
  ima_mask(find(ima_mask~=0))=1;
else
  ima_mask=ones(xdim,ydim,zdim);
end
fovx=double(ainfo.PixelDimensions(1))*double(xdim);
fovy=double(ainfo.PixelDimensions(2))*double(ydim);
fovz=double(ainfo.PixelDimensions(3))*double(zdim);

% use coord system where y is A-P, x is R-L, Z is superior, y is posterior, 
% so for a right-handed coord sys, x must be positive in the left
% do rotation and then translation adds to result

if (exist(motionfile)<2)
  motionfile='motion.txt';
end
motionraw=textread(motionfile);
zrot=motionraw(:,2)*3.14159/180.;
xrot=motionraw(:,3)*3.14159/180.;
yrot=motionraw(:,4)*3.14159/180.;
ztrans=motionraw(:,5);
xtrans=motionraw(:,6);
ytrans=motionraw(:,7);
%assuming it is centered...  3dvolreg assumes so
xmin=-fovx/2.;
xmax=fovx/2.;
ymin=-fovy/2.;
ymax=fovy/2.;
zmin=-fovz/2.;
zmax=fovz/2.;
dx=(xmax-xmin)/xdim;
dy=(ymax-ymin)/ydim;
dz=(zmax-zmin)/zdim;
sz=sin(zrot);
cz=cos(zrot);
sy=sin(yrot);
cy=cos(yrot);
sx=sin(xrot);
cx=cos(xrot);

for i=1:xdim
  x=((i-xdim/2.)*dx)*ones(tdim,1);
  for j=1:ydim
    y=((j-ydim/2.)*dy)*ones(tdim,1);
    for k=1:zdim
      z=((k-(zdim/2.))*dz)*ones(tdim,1);
      voxel=squeeze(ima(i,j,k,:));
      if (ima_mask(i,j,k)==0)
        for q=1:tdim
          ima_reg(i,j,k,q)=voxel(q);
        end
        continue;
      end

      xprime=(cz.*cy).*x              - (sz.*cy).*y              + sy.*z     + xtrans;
      yprime=(sz.*cx - cz.*sy.*sx).*x + (cz.*cx - sz.*sy.*sx).*y - cy.*sx.*z + ytrans;
      zprime=(sz.*sx - cz.*sy.*cx).*x + (cz.*sx + sz.*sy.*cx).*y + cy.*cx.*z + ztrans;

      xdelta=x-xprime;
      ydelta=y-yprime;
      zdelta=z-zprime;
      %rdelta=sqrt(power(xprime-x,2)+power(yprime-y,2)+power(zprime-z,2));

      % remove correlations between voxel and xdelta,ydelta,zdelta, applied to voxel
      A=[xdelta' (xdelta.^2)' ydelta' (ydelta.^2)' zdelta' (zdelta.^2)'  ones(tdim,1)];
      % QR-decomposition
      [Q,R] = qr(A,0);
      % matrix division to get amplitudes of fits
      p = R\(Q'*voxel);
      % don't remove mean signal level, so set amplitude of mean signal fit to 0
      p(end)=0;
      % and save this corrected voxel into ima_reg 4-D volume
      ima_reg(i,j,k,:)=voxel-A*p;
      % residuals
      res=voxel-A*p;
      % mean square error
      mse=res'*res./(dof+1);
      Rinv=pinv(R);
      % error covariance matrix
      covb=(Rinv*Rinv')*mse;
      % get standardized error (variance that is not explained by fit to design matrix)
      stand_err=sqrt(diag(covb));
      % t-statistic of 2ndorder moco correlation
      tim_moco(i,j,k,:)=p(1:end-1)./stand_err(1:end-1);
    end
  end
end

disp('re-transposing corrected image due to MATLAB''s behaviour with ANALYZE format files, and saving output as moco2.sdt');
for z=1:zdim
 for t=1:tdim
  ima_reg(:,:,z,t)=squeeze(ima_reg(:,:,z,t))';
 end
end

fp=fopen('moco2.sdt','w');
fwrite(fp,round(reshape(ima_reg,[xdim ydim*zdim*tdim])),'short');
fclose(fp);

