#! /bin/bash

epi=$1
epi_mask=$2
slice_timing="siemens-alt-asc"
echo "using $slice_timing for slice timing - correct this in script if wrong"
# test if NIFTI_GZ format
a=`echo $epi | grep gz`
if [ ! -z $a ] ; then
  gunzip $epi
  gunzip $epi_mask
  epi=`echo $epi | sed "s/.gz//"`
  epi_mask=`echo $epi_mask | sed "s/.gz//"`
fi
b=`echo $epi | grep nii`
if [ ! -z $b ] ; then
  epi=`echo $epi | sed "s/.nii//"`
  epi_mask=`echo $epi_mask | sed "s/.nii//"`
  suffix=".nii"
  fsuffix=".nii"
fi
c=`echo $epi | grep "+orig"`
if [ ! -z $c ] ; then
  epi=`echo $epi | sed "s/+orig//"`
  epi_mask=`echo $epi_mask | sed "s/+orig//"`
  suffix="+orig"
  fsuffix="+orig.BRIK"
fi

if [ -z $epi ] ; then
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  exit
fi
if [ -z $epi_mask ] ; then
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  exit
fi
# test for presence of both files
if [ ! -f $epi$fsuffix ] ; then
  echo "*****   $epi$fsuffix does not exist"
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  echo "Files must be in NIFTI or AFNI BRIK format"
  exit
fi
if [ ! -f $epi_mask$fsuffix ] ; then
  echo "*****   $epi_mask$fsuffix does not exist"
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  echo "Files must be in NIFTI or AFNI BRIK format"
  exit
fi

epi=$epi$suffix
epi_mask=$epi_mask$suffix

 # PESTICA convert to phase using 3dretroicor
 rm retroicor+orig.*
 echo "3dretroicor -threshold 0 -order 1 -card card_pestica.dat -cardphase cardphase.dat -resp resp_pestica.dat -respphase respphase.dat $epi"
 3dretroicor -threshold 0 -order 1 -card card_pestica.dat -cardphase cardphase.dat -resp resp_pestica.dat -respphase respphase.dat $epi
 rm retroicor+orig.*

 # PESTICA: use physio phase to get IRFs in data - the cardiac estimators are dithered slightly due to the filtering (we will fix that below...)
 echo "Getting IRFs - first round"
 echo "matlab  -nojvm -nosplash -r addpath $PESTICA_DIR; addpath $PESTICA_DIR/matlab_retroicor; load cardphase.dat; load respphase.dat; retroicor_get_irf('$epi',cardphase,respphase,5,'$slice_timing','$epi_mask'); exit;"
       matlab  -nojvm -nosplash -r "addpath $PESTICA_DIR; addpath $PESTICA_DIR/matlab_retroicor; load cardphase.dat; load respphase.dat; retroicor_get_irf('$epi',cardphase,respphase,5,'$slice_timing','$epi_mask'); exit;"

 cp impulse_responses.mat pestica/impulse_responses_firstpass.mat

 # use the data to adjust the dithering of each cardiac peak (when using parallel monitored pulse, this doesn't do much, but it does fix the PESTICA cardiac estimators)
 echo "adjusting and getting IRFs - second round"
 echo "matlab  -nojvm -nosplash -r addpath $PESTICA_DIR; addpath $PESTICA_DIR/matlab_retroicor; load impulse_responses.mat; fit_each_physio_peak(cardph,coeffs_card,'$epi','$epi_mask',cmask,'$slice_timing'); load physio_fitted.mat; retroicor_get_irf('$epi',cardphase,respph,5,'$slice_timing','$epi_mask'); exit;"
       matlab  -nojvm -nosplash -r "addpath $PESTICA_DIR; addpath $PESTICA_DIR/matlab_retroicor; load impulse_responses.mat; fit_each_physio_peak(cardph,coeffs_card,'$epi','$epi_mask',cmask,'$slice_timing'); load physio_fitted.mat; retroicor_get_irf('$epi',cardphase,respph,5,'$slice_timing','$epi_mask'); exit;"

 mv impulse_responses.mat pestica/impulse_responses_secondpass.mat

 echo "Applying IRFs and correcting data with IRF-RETROICOR"
 echo "writing out corrected data as: irfretroicor"
 echo "writing out statistical coupling maps as: coupling_irfret_card coupling_irfret_resp"
 echo "matlab  -nojvm -nosplash -r addpath $PESTICA_DIR; addpath $PESTICA_DIR/matlab_retroicor; load pestica/impulse_responses_secondpass.mat; irf_retroicor('$epi',cardph,respph,coeffs_card,coeffs_resp,'$slice_timing','$epi_mask'); exit;"
       matlab  -nojvm -nosplash -r "addpath $PESTICA_DIR; addpath $PESTICA_DIR/matlab_retroicor; load pestica/impulse_responses_secondpass.mat; irf_retroicor('$epi',cardph,respph,coeffs_card,coeffs_resp,'$slice_timing','$epi_mask'); exit;"

if [ ! -z $a ] ; then
  gzip $epi
  gzip $epi_mask
fi

