% steps undertaken to run PESTICA on test dataset

slice_timing='siemens-alt-asc';
%slice_timing='alt-asc';
full_tdim=210;

% assumes you have run the shell scripts:
% -bash-3.1$ ./run_pestica_ica.sh
% -bash-3.1$ ./run_pestica_est.sh
% -bash-3.1$ ./filter_pestica_est.sh
% at this point, the PESTICA estimators are written as card_pestica.dat and resp_pestica.dat
% check the coregistration files for accuracy however...

  % for validation, you need parallel monitored pulse and respiration from the scan you are running PESTICA on
  % create text files of pulse and respiration from Siemens files and synchronize to trigger
  % (in this example, the files have prefix myPmuSignal and reside in current working directory)
  [tdim,fcard,fresp]=fix_siemens_pmu('myPmuSignal',TR,1,1,1,full_tdim);
  % store raw pmu data in .dat form for easy reading
  fp=fopen('resp.dat','w');
  fprintf(fp,'%g\n',fresp);
  fclose(fp);
  fp=fopen('card.dat','w');
  fprintf(fp,'%g\n',fcard);
  fclose(fp);
  % in this case, first ten volumes were removed from the ep2d volumes
  tdim=full_tdim-10;
  % store PMU data for last 200 volumes (exclude first 10*50*2 pmu ticks - Siemens samples these at 50Hz)
  resp_r1=fresp(1001:end);
  fp=fopen('resp_200vols.dat','w');
  fprintf(fp,'%g\n',resp_r1);
  fclose(fp);
  card_r1=fcard(1001:end);
  fp=fopen('card_200vols.dat','w');
  fprintf(fp,'%g\n',card_r1);
  fclose(fp);

  % search for phase shift in cardiac data w.r.t. independent components, maxing out at 0.8 second later and after (800 ms)
  % this is necessary because pulse at fingertip is not optimally same lag and the Siemens equipment seems to have a different
  % sample rate
  [opt_card]=optimize_pmu(comps,card_r1,zdim,slice_timing,TR,TE);

% assumes you have parallel measured pulse and respiration for this scan, named card.dat and resp.dat
card=textread('card.dat');
resp=textread('resp.dat');
% results, check against the parallel measured PMU data: resample to slice-acquisition timing
c=assemble_slices_to_timeseries(disassemble_timeseries_to_slices(card,zdim,tdim,TR,TE,slice_timing),zdim,tdim,TR,TE,slice_timing,ones(zdim,1));
r=assemble_slices_to_timeseries(disassemble_timeseries_to_slices(resp,zdim,tdim,TR,TE,slice_timing),zdim,tdim,TR,TE,slice_timing,ones(zdim,1));
% de-mean and variance normalize for display
c=(c-mean(c))/std(c);
r=(r-mean(r))/std(r);

load resp_rawest.dat
load card_rawest.dat
load resp_pestica.dat
load card_pestica.dat

% spit out the raw correlation to our parallel measured pulse and respiration
corr(resp_rawest',r')
corr(card_rawest',c')

corr(resp_pestica',r')
corr(card_pestica',c')

