
export MATLAB_AFNI_DIR=/mnt/autofs/netScratch/ebeall/afni_matlab

# edit the hard-coded base directory containing the matlab code and the averaged volumes
export PESTICA_DIR=/mnt/autofs/netScratch/ebeall/pestica_afni_v1_2
export PATH=$PATH:$PESTICA_DIR

# edit your matrix size (approximate, decide which is closer to your voxel volume, 16mm^3 or 64mm^3)
# one set was created using 2x2x4mm voxels (16mm^3), the other with 4x4x4mm voxels (64mm^3)
export PESTICA_VOL=16mm3
#export PESTICA_VOL=64mm3

if [ ! -e $PESTICA_DIR/.firsttime ] ; then
  touch $PESTICA_DIR/.firsttime

  rm -f $PESTICA_DIR/resp_mean_mni.nii $PESTICA_DIR/card_mean_mni.nii

  ln -s $PESTICA_DIR/pestica_volumes/resp_pestica_"$PESTICA_VOL"_avg_mni.nii $PESTICA_DIR/resp_mean_mni.nii

  ln -s $PESTICA_DIR/pestica_volumes/card_pestica_"$PESTICA_VOL"_avg_mni.nii $PESTICA_DIR/card_mean_mni.nii
fi

