function [fpmu_est]=view_and_correct_estimator(pmu_est,zdim,TR)
%f_s must be in Hz, for the sample rate of the estimator (slices per second)
if (TR>20)
  TR=TR/1000;
end
f_s=zdim/TR;

h=figure;
plot(linspace(60*f_s/length(pmu_est),60*f_s,length(pmu_est)),abs(fft(pmu_est).^2));
xlabel('sampling frequency (bpm)')
xlim([0 120]);
% zoom in horizontally on the pmu peak
a=version('-release');
if (str2num(a(1:4))<2007)
  %disp('if version is less than R2007a, zoom does not have this functionality');
  zoom;
  disp('hit enter (at this matlab command prompt) when you have zoomed _around_ (only horizontal');
  disp('zoom matters) a reasonable pmu peak cardiac 62+-8bpm (range 48-85), resp 17+-4bpm (range 10-24)');
else
  h = zoom;
  zoom;
  set(h,'Motion','horizontal','Enable','on');
  disp('hit enter (at this matlab command prompt) when you have zoomed on a reasonable pmu');
  disp('peak cardiac 62+-8bpm (range 48-85), resp 17+-4bpm (range 10-24)');
end
pause;
x=xlim/f_s;
x=x/60;
if (x(1)<f_s/length(pmu_est));
  x(1)=f_s/length(pmu_est);
end
fpmu_est=tfilter_fft(pmu_est-tfilter_fft(pmu_est,x(1)),x(2));
close

