function [acquisition_timing,slice_timing]=get_slice_timing(slice_mode,zdim,TR,TE);
%function [acquisition_timing,slice_timing]=get_slice_timing(slice_mode,zdim,TR,TE);
% function to obtain slice acquisition timing and order for various acquisition schemes
% including fully user-defined timing. Warning on user-defined timing: input in same scale 
% as TR (use the real timing of the slice acquisition within the volume, 
% for example, use slice_mode=linspace(0,TR-TR/zdim,zdim)+TE; which is equivalent to seq-asc

if strcmp(slice_mode,'alt-asc')
  % GE or phillips scanners start with first slice always, also don't have offset:
  acquisition_timing=linspace(0,TR-TR/zdim,zdim)+TE;
  slice_timing([1:2:zdim 2:2:zdim])=acquisition_timing;
elseif strcmp(slice_mode,'seq-asc')
  acquisition_timing=linspace(0,TR-TR/zdim,zdim)+TE;
  slice_timing=acquisition_timing;
elseif strcmp(slice_mode,'alt-desc')
  acquisition_timing=linspace(0,TR-TR/zdim,zdim)+TE;
  slice_timing([1:2:zdim 2:2:zdim])=fliplr(acquisition_timing);
elseif strcmp(slice_mode,'seq-desc')
  acquisition_timing=linspace(0,TR-TR/zdim,zdim)+TE;
  slice_timing=fliplr(acquisition_timing);
elseif strcmp(slice_mode,'siemens-alt-asc')
  % with siemens scanners and odd number of slices, start with odds
  % otherwise if even number of slices, start with evens
  offset=20.0;
  acquisition_timing=linspace(0,TR-TR/zdim-offset,zdim)+TE;
  slice_timing([2-mod(zdim,2):2:zdim 1+mod(zdim,2):2:zdim-1])=acquisition_timing;
elseif strcmp(slice_mode,'siemens-alt-desc')
  offset=20.0;
  acquisition_timing=linspace(0,TR-TR/zdim-offset,zdim)+TE;
  slice_timing([2-mod(zdim,2):2:zdim 1+mod(zdim,2):2:zdim-1])=fliplr(acquisition_timing);
elseif (isnumeric(slice_mode))
  if (length(slice_mode)~=zdim)
    disp('length of numeric slice timing for slice_mode is incompatible with number of slices:');
    slice_mode
    size(slice_mode)
    return
  end
  disp('warning, using user-defined slice timing, make sure it is in same timescale as TR');
  acquisition_timing=slice_mode;
  slice_timing=acquisition_timing;
else
  disp('undefined input for slice_mode:');
  slice_mode
  disp('allowed possibilities: siemens-alt-asc, siemens-alt-desc, alt-asc, alt-desc, seq-asc, seq-desc');
  disp('or a numeric vector of the acquisition time for each slice');
  return
end

