function fit_each_physio_peak(phasedata,irf_card1,ep2d_filename,mask_filename,cmask,slice_timing)
% function fcardph=fit_each_physio_peak(phasedata,irf_card1,ep2d_filename,mask_filename,cmask,slice_timing)
% uses output of retroicor_get_irf.m - irf_card1=the first cardiac IRF, 
% cmask=cardiac masked voxels
% takes cardiac phase input, finds minimum periodicity,
% and loops over each peak and starts a shift search for optimal coupling
% (shifts are in increments of sample freq, over range of minimum periodicity away from adjacent peaks)
% The optimal detected peak location is now at the max histogrammed tscore for this shift.  As sanity 
% check, we normalize by hist tscore for non-cmasked voxels (use same number but
% randomly distributed inside mask).  Output is new cardiac and phase vectors.

mat_afnidir=getenv('MATLAB_AFNI_DIR');
addpath(mat_afnidir);
Opt.Format = 'matrix';
[err, ima, ainfo, ErrMessage]=BrikLoad(ep2d_filename, Opt);
xdim=double(ainfo.DATASET_DIMENSIONS(1));
ydim=double(ainfo.DATASET_DIMENSIONS(2));
zdim=double(ainfo.DATASET_DIMENSIONS(3));
tdim=double(ainfo.DATASET_RANK(2));
TR=1000*double(ainfo.TAXIS_FLOATS(2));
% f_s=cardiac sampling frequency
f_s=zdim/TR;
if (tdim<50)
  disp('small temporal dimension, not recommended');
end
if (exist('ext_option')==0)
  ext_option=0;
end
if (exist(mask_filename)==2)
  [err,mask,minfo,ErrMessage]=BrikLoad(mask_filename, Opt);
  mask(find(mask~=0))=1;
else
  mask=ones(xdim,ydim,zdim);
  mask(find(squeeze(ima(:,:,:,1)))==0)=0;
end
ima=double(reshape(ima,[xdim ydim zdim tdim]));
mask=double(reshape(mask,[xdim ydim zdim]));

% COUNT NOMINAL NUMBER OF PEAKS
lenp=length(phasedata);
ncycles=0;
for i=1:lenp-1
  if (phasedata(i)-phasedata(i+1)>3.)
    ncycles=ncycles+1;
  end
end
% FIND THE INDICES OF THOSE PEAKS
peak_indices=0;
cyclelen=0;
for pass=1:2
  if (pass==2)
    averagecycle=round(mean(cyclelen));
  end
  for i=1:ncycles
    if (i==1)
      beginning=0;
      ending=find_period_start(1,phasedata);
      cyclelen(i)=ending-beginning+1;
    else
      beginning=ending;
      ending=find_period_start(i,phasedata);
      cyclelen(i)=ending-beginning+1;
    end
    if (pass==2)
      peak_indices(i)=ending;
    end
  end
end

% get periodicity stats
minp=min(peak_indices(2:end)-peak_indices(1:end-1));
meanp=mean(peak_indices(2:end)-peak_indices(1:end-1));
maxp=max(peak_indices(2:end)-peak_indices(1:end-1));
stdp=std(peak_indices(2:end)-peak_indices(1:end-1));

% periodicity - convert into estimate of quality by taking difference in periodicity and making stat from where it lies in distribution
%cp=zeros(lenp,1);
%cp(peak_indices)=1;
%plot(cp);
%hold on
%plot(pchip((peak_indices(2:end)+peak_indices(1:end-1))/2,peak_indices(2:end)-peak_indices(1:end-1),1:lenp)-meanp,'r');
%return

ima=reshape(ima,[xdim*ydim zdim tdim]);
%dof=double(tdim-(4+1));
dof=double(tdim-(10+1));
orig_peak_indices=peak_indices;
% now loop over peaks, and for each one, do full regression on cmask voxels and non-cmask voxels (randomly chosen within ep2d_mask file so we have same number)
for i=1:length(peak_indices)
  % for peak, do shift search from minp from previous peak (or from 1 if first peak or len if last peak) up to minp from next peak
  if (i==1); stp=1; else ; stp=orig_peak_indices(i-1)+minp; end;
  if (i==length(orig_peak_indices)); enp=lenp; else ; enp=orig_peak_indices(i+1)-minp; end
  if (stp<orig_peak_indices(i)-minp) ; stp=orig_peak_indices(i)-minp; end
  if (enp>orig_peak_indices(i)+minp) ; enp=orig_peak_indices(i)+minp; end
  pshifts=stp:enp;
  %tscore_cmask=zeros(length(pshifts),1);
  %tscore_noncmask=zeros(length(pshifts),1);
  tscore_cmask=zeros(length(pshifts),length(find(cmask==1)));
  tscore_noncmask=zeros(length(pshifts),length(find(cmask==1)));
  for j=1:length(pshifts)
    % make up newcardph with shift on current peak
    new_peak_indices=orig_peak_indices;
    new_peak_indices(i)=pshifts(j);
    newcardph=convert_into_newphasedata(lenp,new_peak_indices);
    % disassemble full timeseries into slices and do regressions, storing tscores for 1st cardiac IRF
    cph=disassemble_timeseries_to_slices(newcardph,zdim,tdim,TR,29,slice_timing);
    n=0;
    for z=1:zdim
      % setup regressor
      c=cph(z,:);
      % use first three IRFs
      A=[(irf_card1(1,1:5)*sin((1:5)'*c)+irf_card1(1,6:end)*cos((1:5)'*c))' (irf_card1(2,1:5)*sin((1:5)'*c)+irf_card1(2,6:end)*cos((1:5)'*c))' (irf_card1(3,1:5)*sin((1:5)'*c)+irf_card1(3,6:end)*cos((1:5)'*c))' ones(tdim,1)];
      %A=[(irf_card1(1,1:5)*sin((1:5)'*c)+irf_card1(1,6:end)*cos((1:5)'*c))' ones(tdim,1)];
      % QR-decomposition
      [Q,R] = qr(A,0);
      % get indices masked in on this slice
      cmaskind=find(reshape(cmask(:,:,z),[xdim*ydim 1])==1);
      cmasklen(z)=length(cmaskind);
      % and indices masked out (yet within brain) on this slice
      noncmaskind=find(reshape(mask(:,:,z)-cmask(:,:,z),[xdim*ydim 1])==1);
      %noncmaskind=noncmaskind(randperm(length(noncmaskind))); noncmaskind=noncmaskind(1:cmasklen(z));
      for k=1:cmasklen(z)
	n=n+1;
        vox=squeeze(ima(cmaskind(k),z,:));
        p = R\(Q'*vox);
        res=vox-A*p;
        ms=res'*res./(dof+1);
        Rinv=pinv(R);
        covb=(Rinv*Rinv')*ms;
        stand_err=sqrt(diag(covb));
	% polarity is arbitrary, but we only want the good cardiac voxels in here
	%t=abs(p(1)/stand_err(1)); if (t<2.5); t=0; end;
	t=abs(p(1:3)./stand_err(1:3)); t=sqrt(sum(t.^2)); if (t<2.5); t=0; end;
        %tscore_cmask(j)=tscore_cmask(j)+t;
	tscore_cmask(j,n)=t;
	continue;
        vox=squeeze(ima(noncmaskind(k),z,:));
        p = R\(Q'*vox);
        res=vox-A*p;
        ms=res'*res./(dof+1);
        Rinv=pinv(R);
        covb=(Rinv*Rinv')*ms;
        stand_err=sqrt(diag(covb));
	% in this case, we do NOT want significantly coupled voxels - these are probably good cardiac voxels
	% and we will be normalizing these out
	t=abs(p(1)/stand_err(1)); if (t>2.5); t=0; end;
	tscore_noncmask(j,n)=t;
      end
    end
  end
  % average tscores across voxels - obtain vector of avg tscore vs shift
  tscore_cmask=mean(tscore_cmask');
  %tscore_noncmask=mean(tscore_noncmask');
  %tscore_cmask=tscore_cmask-tscore_noncmask;
  % select best peak - but only shift if compelling
  peak_indices(i)=pshifts(find(tscore_cmask==max(tscore_cmask)));
end

% at end of fixing phase data, now convert back into proper phase
cardphase=convert_into_newphasedata(lenp,peak_indices);

% save data output
save physio_fitted.mat cardphase
return

function new_phasedata=convert_into_newphasedata(len,peak_indices)
 % get average period
 avg_period=mean(peak_indices(2:end)-peak_indices(1:end-1));
  % CODE TAKEN FROM get_physio_phase()
 new_phasedata=zeros(len,1);
 % use avg_period to estimate initial and end slope
 for j=1:peak_indices(1)
  if (peak_indices(1)==1)
    new_phasedata(j)=pi;
  else
    % if peak_indices(1)>avg_period, we should assume we missed the first one, put it in here either at peak_indices(1)-avg_period,
    % or halfway between peak_indices(1)-avg_period and one (if peak_indices(1) is more than double avg_period)
    if (peak_indices(1)>avg_period)
      if (peak_indices(1)>2*avg_period)
        new_peak_index=round((peak_indices(1)-avg_period)/2);
      else
        new_peak_index=peak_indices(1)-avg_period;
      end
      len=peak_indices(1)-new_peak_index;
      if (j>new_peak_index)
        new_phasedata(j)=((j-new_peak_index-1)*(2*pi/len))-pi;
        %new_phasedata(j)=((j-new_peak_index-(peak_indices(i)+1))*(2*pi/len))-pi;
      else
        new_phasedata(j)=j*(2*pi/new_peak_index)-pi;
      end
    else
      new_phasedata(j)=((j+abs(avg_period-peak_indices(1))-1)*(2*pi/avg_period))-pi;
    end
  end
 end
 % CONVERT PEAKS INDICES INTO PHASE DATA FOR MID PEAKS
 for i=1:length(peak_indices)-1
  len=peak_indices(i+1)-peak_indices(i);
  for j=peak_indices(i)+1:peak_indices(i+1)
    new_phasedata(j)=((j-(peak_indices(i)+1))*(2*pi/len))-pi;
  end
 end
 % CONVERT PEAKS INDICES INTO PHASE DATA FOR END PEAK
 %len=abs(avg_period-(len-peak_indices(end)));
 len=avg_period;
 for j=peak_indices(end)+1:len
  if (peak_indices(end)+1>=len)
    new_phasedata(j)=-pi;
  else
    new_phasedata(j)=((j-(peak_indices(end)+1))*(2*pi/len))-pi;
  end
 end

% OFFSET DATA FOR CARDIAC DATA EXPECTED BY RETROICOR
 new_phasedata=new_phasedata+pi;
 return

function a=find_period_start(cycle,inputphase)
  thiscycle=0;
  for q=1:length(inputphase)-1
    if (inputphase(q)-inputphase(q+1)>3.)
      thiscycle=thiscycle+1;
      if (cycle==thiscycle)
        a=q;
	return;
      end
    end
  end
  disp('did not find this cycle');
  a=0;
  return

