function peak_extra
  global seg yl nseg maxseg c cp minp min_period cp_newpeaks cp_extrapeaks avg_period f_s h

  hz = zoom;
  zoom;
  set(hz,'Motion','horizontal','Enable','on');
  disp('zoom in on a peak you think is spurious, then hit enter');
  disp('zoom in til the extra peak is in the midpoint of your zoom');
  pause;
  % find nearest peak in cp
  selpeak=round(mean(xlim*f_s));
  a=find(cp==1);
  selpeak=a(find(abs(a-selpeak)==min(abs(a-selpeak))));
  cp_extrapeaks(selpeak)=2;
  cp(selpeak)=0;
  figure(h);
  hold off
  plot(linspace(1/f_s,length(c)/f_s,length(c)),c);
  hold on
  plot(linspace(1/f_s,length(c)/f_s,length(c)),cp_extrapeaks,'g','linewidth',2);
  plot(linspace(1/f_s,length(c)/f_s,length(c)),cp_newpeaks,'r','linewidth',2);
  plot(linspace(1/f_s,length(c)/f_s,length(c)),cp,'k','linewidth',2);
  hold off
  zoom;
  ylim(yl);

