#! /bin/bash

epi=$1
epi_mask=$2
slice_timing="siemens-alt-asc"
echo "using $slice_timing for slice timing - correct this in script if wrong"
# test if NIFTI_GZ format
a=`echo $epi | grep gz`
if [ ! -z $a ] ; then
  gunzip $epi
  gunzip $epi_mask
  epi=`echo $epi | sed "s/.gz//"`
  epi_mask=`echo $epi_mask | sed "s/.gz//"`
fi
b=`echo $epi | grep nii`
if [ ! -z $b ] ; then
  epi=`echo $epi | sed "s/.nii//"`
  epi_mask=`echo $epi_mask | sed "s/.nii//"`
  suffix=".nii"
  fsuffix=".nii"
fi
c=`echo $epi | grep "+orig"`
if [ ! -z $c ] ; then
  epi=`echo $epi | sed "s/+orig//"`
  epi_mask=`echo $epi_mask | sed "s/+orig//"`
  suffix="+orig"
  fsuffix="+orig.BRIK"
fi

if [ -z $epi ] ; then
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  exit
fi
if [ -z $epi_mask ] ; then
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  exit
fi
# test for presence of both files
if [ ! -f $epi$fsuffix ] ; then
  echo "*****   $epi$fsuffix does not exist"
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  echo "Files must be in NIFTI or AFNI BRIK format"
  exit
fi
if [ ! -f $epi_mask$fsuffix ] ; then
  echo "*****   $epi_mask$fsuffix does not exist"
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  echo "Files must be in NIFTI or AFNI BRIK format"
  exit
fi

 # PESTICA coreg to template
 echo "Coregistration to EPI template"
 3dAllineate -automask -prefix pestica/$epi_mask.crg2mni.nii -source $epi_mask$suffix -base $PESTICA_DIR/meanepi_mni.nii -1Dmatrix_save pestica/$epi_mask.coreg.mni.1D

 cat_matvec pestica/$epi_mask.coreg.mni.1D -I -ONELINE > pestica/mni.coreg.$epi_mask.1D
 3dAllineate -prefix pestica/resp_PESTICA2.nii -source $PESTICA_DIR/resp_mean_mni.nii -base $epi_mask$suffix -1Dmatrix_apply pestica/mni.coreg.$epi_mask.1D
 3dAllineate -prefix pestica/card_PESTICA2.nii -source $PESTICA_DIR/card_mean_mni.nii -base $epi_mask$suffix -1Dmatrix_apply pestica/mni.coreg.$epi_mask.1D
 echo "Obtaining PESTICA estimators"
 echo  matlab  -nojvm -nosplash -r "addpath $PESTICA_DIR; [card,resp]=apply_PESTICA2(15,'$epi$suffix','$epi_mask$suffix','$slice_timing'); fp=fopen('card_rawest.dat','w'); fprintf(fp,'%g\n',card); fclose(fp); fp=fopen('resp_rawest.dat','w'); fprintf(fp,'%g\n',resp); fclose(fp); exit;"
       matlab  -nojvm -nosplash -r "addpath $PESTICA_DIR; [card,resp]=apply_PESTICA2(15,'$epi$suffix','$epi_mask$suffix','$slice_timing'); fp=fopen('card_rawest.dat','w'); fprintf(fp,'%g\n',card); fclose(fp); fp=fopen('resp_rawest.dat','w'); fprintf(fp,'%g\n',resp); fclose(fp); exit;"

if [ ! -z $a ] ; then
  gzip $epi$suffix
  gzip $epi_mask$suffix
fi

