#! /bin/bash

epi=$1
epi_mask=$2
# test if NIFTI_GZ format
a=`echo $epi | grep gz`
if [ ! -z $a ] ; then
  gunzip $epi
  gunzip $epi_mask
  epi=`echo $epi | sed "s/.gz//"`
  epi_mask=`echo $epi_mask | sed "s/.gz//"`
fi
b=`echo $epi | grep nii`
if [ ! -z $b ] ; then
  epi=`echo $epi | sed "s/.nii//"`
  epi_mask=`echo $epi_mask | sed "s/.nii//"`
  suffix=".nii"
  fsuffix=".nii"
fi
c=`echo $epi | grep "+orig"`
if [ ! -z $c ] ; then
  epi=`echo $epi | sed "s/+orig//"`
  epi_mask=`echo $epi_mask | sed "s/+orig//"`
  suffix="+orig"
  fsuffix="+orig.BRIK"
fi

if [ -z $epi ] ; then
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  exit
fi
if [ -z $epi_mask ] ; then
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  exit
fi
# test for presence of both files
if [ ! -f $epi$fsuffix ] ; then
  echo "*****   $epi$fsuffix does not exist"
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  echo "Files must be in NIFTI or AFNI BRIK format"
  exit
fi
if [ ! -f $epi_mask$fsuffix ] ; then
  echo "*****   $epi_mask$fsuffix does not exist"
  echo "Usage example: ./run_pestica_ica.sh ep2d_pace_132vols ep2d_pace_132vols_mask"
  echo "Files must be in NIFTI or AFNI BRIK format"
  exit
fi

epi=$epi$suffix
epi_mask=$epi_mask$suffix
 echo "running slicewise Infomax temporal ICA"
 echo  matlab  -nojvm -nosplash -r "addpath $PESTICA_DIR; addpath $PESTICA_DIR/eeglab; prepare_ICA_decomp(15,'$epi','$epi_mask'); exit;"
       matlab  -nojvm -nosplash -r "addpath $PESTICA_DIR; addpath $PESTICA_DIR/eeglab; prepare_ICA_decomp(15,'$epi','$epi_mask'); exit;"

if [ ! -z $a ] ; then
  gzip $epi
  gzip $epi_mask
fi

