function write_data
  global seg yl nseg maxseg c cp minp min_period cp_newpeaks cp_extrapeaks avg_period f_s h

  disp('Writing Data File card and cardphase into physio.mat');
  card=c;
  % turn cp back into phase data
  peak_indices=find(cp==1);
  phasedata=0*cp;

  % CODE TAKEN FROM get_physio_phase()
new_phasedata=zeros(length(phasedata),1);
% use avg_period to estimate initial and end slope
for j=1:peak_indices(1)
  if (peak_indices(1)==1)
    new_phasedata(j)=pi;
  else
    % if peak_indices(1)>avg_period, we should assume we missed the first one, put it in here either at peak_indices(1)-avg_period,
    % or halfway between peak_indices(1)-avg_period and one (if peak_indices(1) is more than double avg_period)
    if (peak_indices(1)>avg_period)
      if (peak_indices(1)>2*avg_period)
        new_peak_index=round((peak_indices(1)-avg_period)/2);
      else
        new_peak_index=peak_indices(1)-avg_period;
      end
      len=peak_indices(1)-new_peak_index;
      if (j>new_peak_index)
        new_phasedata(j)=((j-new_peak_index-1)*(2*pi/len))-pi;
        %new_phasedata(j)=((j-new_peak_index-(peak_indices(i)+1))*(2*pi/len))-pi;
      else
        new_phasedata(j)=j*(2*pi/new_peak_index)-pi;
      end
    else
      new_phasedata(j)=((j+abs(avg_period-peak_indices(1))-1)*(2*pi/avg_period))-pi;
    end
  end
end
% CONVERT PEAKS INDICES INTO PHASE DATA FOR MID PEAKS
for i=1:length(peak_indices)-1
  len=peak_indices(i+1)-peak_indices(i);
  for j=peak_indices(i)+1:peak_indices(i+1)
    new_phasedata(j)=((j-(peak_indices(i)+1))*(2*pi/len))-pi;
  end
end
% CONVERT PEAKS INDICES INTO PHASE DATA FOR END PEAK
%len=abs(avg_period-(length(phasedata)-peak_indices(end)));
len=avg_period;
for j=peak_indices(end)+1:length(phasedata)
  if (peak_indices(end)+1>=length(phasedata))
    new_phasedata(j)=-pi;
  else
    new_phasedata(j)=((j-(peak_indices(end)+1))*(2*pi/len))-pi;
  end
end

% OFFSET DATA FOR CARDIAC DATA EXPECTED BY RETROICOR
cardphase=new_phasedata+pi;
save physio.mat card cardphase
fp=fopen('cardphase_fixed.dat','w'); fprintf(fp,'%g\n',cardphase); fclose(fp);
close(h);

