function [opt_pmu]=optimize_pmu(comps,pmu,zdim,slice_timing,TR,TE,maxshift,maxresample,nshifts,nsamps)
%function [opt_pmu]=optimize_pmu(comps,pmu,zdim,slice_timing,TR,TE,maxshift,maxresample,nshifts,nsamps)
% function to take measured PMU data and tICA decomposition and 
% finds the optimal temporal shift and resampling factor for maximal 
% correlation with ICA data within preset limits
%
% maxshift must be in same units as TR (eg, milliseconds or seconds)
% default maxshift=0.5TR, default maxresample=0.5% (0.005)

mnidir=getenv('PESTICA_DIR');
if (length(mnidir)==0)
  disp('you must have environment variable PESTICA_DIR set to point to PESTICA distribution');
  return
end

cd pestica
[w,zstart]=system(sprintf('ls pestica_%dcomps_slice*.mat | sed "s/pestica_%dcomps_slice//" | sed "s/.mat//" | sort -n',comps,comps));
zstart=[str2num(zstart)'];

for z=zstart
  load(sprintf('pestica_%dcomps_slice%d.mat',comps,z));
  clear D;
  % first determine variance contribution from each A(j,:) timecourse and the spatial extent of the mixing map m
  for j=1:comps
    timeseries=squeeze(A(j,:));
    % de-mean
    timeseries=timeseries-mean(timeseries);
    % variance normalize
    D(j,:)=timeseries/std(timeseries);
  end
  slice_timeseries(z,:,:)=D;
end

cd ..
tdim=size(A,2);

if (exist('TR')==0)
  TR=2000;
end
if (exist('TE')==0)
  TE=29;
end
TR=double(TR);
TE=double(TE);
if (exist('slice_timing')==0)
  slice_timing='alt-asc'
  disp('using interleaved ascending ''alt-asc'' for the slice timing');
end
if (exist('maxshift')==0)
  maxshift=0.5*TR;
end
if (exist('maxresample')==0)
  maxresample=0.5;
end
if (exist('nsamps')==0)
  % odd number to allow a null resample/shift (middle resample/shift = 0)
  nsamps=9;
end
if (exist('nshifts')==0)
  nshifts=9;
end
% put maxshift in units of volume
maxshift=maxshift/TR;
shifts=linspace(-maxshift,maxshift,nshifts);
resamples=linspace(-maxresample,maxresample,nsamps);
% setup slice timing of physiologic data, for data shifted by 1 volume forward and backwards
% and resamples by up to 1 percent
% and re-order by slice-acquisition
if (size(pmu,2)~=1)
  pmu=pmu';
end
c=pmu;
c=(c-mean(c))/std(c);
f_c=length(c)/tdim;
c(1:round(maxshift*f_c))=0;
c(end-round(maxshift*f_c)+1:end)=0;
for r=1:length(resamples)
  for s=1:length(shifts)
    % offset for time shift search according to shifts(s)
    offset=abs(round(f_c*shifts(s)));
    if (shifts(s)<0)
      temp=[zeros(offset,1); c(1:end-offset)];
    elseif (shifts(s)==0)
      temp=c;
    else
      temp=[c(offset+1:end); zeros(offset,1)];
    end
    % resample according to resamples(r) factor
    if (resamples(r)>0)
      extralen=round(length(temp)*resamples(r)/100);
      inputmesh=[1:length(temp)+extralen];
      inputmesh=inputmesh(round(extralen/2):end-round(extralen/2));
      inputmesh=inputmesh(1:length(temp));
    elseif (resamples(r)<0)
      missinglen=-round(length(temp)*resamples(r)/100);
      inputmesh=[round(missinglen/2):length(temp)-round(missinglen/2)];
      temp=temp(round(missinglen/2):end-round(missinglen/2));
      inputmesh=inputmesh(1:length(temp));
    else
      pmu_slices(r,s,:,:)=disassemble_timeseries_to_slices(temp,zdim,tdim,TR,TE,slice_timing);
      continue;
    end
    outputmesh=[1:length(temp)];
    % resample with piecewise cubic
    temp=pchip([(2*inputmesh(1)-inputmesh(2)) inputmesh (2*inputmesh(end)-inputmesh(end-1))],[temp(1); temp; temp(end)],[(2*outputmesh(1)-outputmesh(2)) outputmesh (2*outputmesh(end)-outputmesh(end-1))]);
    temp=temp(2:end-1);
    % slice timing
    %pmu_slices(r,s,:,:)=disassemble_timeseries_to_slices(temp,zdim,tdim,slice_timing,TR);
    pmu_slices(r,s,:,:)=disassemble_timeseries_to_slices(temp,zdim,tdim,TR,TE,slice_timing);
  end
end

r_c=zeros(length(resamples),length(shifts),zdim,comps);
for z=1:zdim
  if (numel(find(zstart==z))==0)
    continue;
  end
  for r=1:length(resamples)
    for s=1:length(shifts)
      for j=1:comps
        r_c(r,s,z,j)=abs(corr(squeeze(pmu_slices(r,s,z,:)),squeeze(slice_timeseries(z,j,:))));
      end
    end
  end
end
r_c(isnan(r_c))=0;

% 3sigma correlation threshold, mean across only those above threshold (TODO)
cutoff=get_correlation_threshold(comps*length(shifts),tdim);

% max across components
m_r_c=max(r_c,[],4);
% mean across slices
mm_r_c=mean(m_r_c,3);
% resamples is first dim, mean across shifts
mres_r_c=mean(mm_r_c,2);
resamp_c=find(mres_r_c==max(mres_r_c));
best_pmu_resample=resamples(resamp_c);
% shifts is second dim, take best resample
msh_r_c=mm_r_c(resamp_c,:);
shift_c=find(msh_r_c==max(msh_r_c));
best_pmu_shift=shifts(shift_c)*TR;

% apply this best shift and resample to the PMU data
c=pmu-mean(pmu);
offset=abs(round(f_c*shifts(shift_c)));
resamp=resamples(resamp_c);
if (shifts(shift_c)<0)
    temp=[zeros(offset,1); c(1:end-offset)];
elseif (shifts(shift_c)==0)
    temp=c;
else
    temp=[c(offset+1:end); zeros(offset,1)];
end
if (resamples(resamp_c)>0)
  extralen=round(length(temp)*resamples(resamp_c)/100);
  inputmesh=[1:length(temp)+extralen];
  inputmesh=inputmesh(round(extralen/2):end-round(extralen/2));
  inputmesh=inputmesh(1:length(temp));
  outputmesh=[1:length(temp)];
  opt_pmu=pchip([(2*inputmesh(1)-inputmesh(2)) inputmesh (2*inputmesh(end)-inputmesh(end-1))],[temp(1); temp; temp(end)],[(2*outputmesh(1)-outputmesh(2)) outputmesh (2*outputmesh(end)-outputmesh(end-1))]);
  opt_pmu=opt_pmu(2:end-1);
elseif (resamples(resamp_c)<0)
  missinglen=-round(length(temp)*resamples(resamp_c)/100);
  inputmesh=[round(missinglen/2):length(temp)-round(missinglen/2)];
  temp=temp(round(missinglen/2):end-round(missinglen/2));
  inputmesh=inputmesh(1:length(temp));
  outputmesh=[1:length(temp)];
  opt_pmu=pchip([(2*inputmesh(1)-inputmesh(2)) inputmesh (2*inputmesh(end)-inputmesh(end-1))],[temp(1); temp; temp(end)],[(2*outputmesh(1)-outputmesh(2)) outputmesh (2*outputmesh(end)-outputmesh(end-1))]);
  opt_pmu=opt_pmu(2:end-1);
else
  opt_pmu=temp;
end
opt_pmu=opt_pmu+mean(pmu);
if (size(opt_pmu,2)>size(opt_pmu,1))
  opt_pmu=opt_pmu';
end
if (length(opt_pmu(:))<length(pmu(:)))
  opt_pmu=pchip(linspace(0,1,length(opt_pmu)+2),[opt_pmu(1); opt_pmu; opt_pmu(end)],linspace(0,1,length(pmu)+2));
  opt_pmu=opt_pmu(2:end-1);
end

save pest_resamples.mat r_c m_r_c mres_r_c msh_r_c best_pmu_shift best_pmu_resample shifts resamples

