function physio_qa(TR,zdim)
% function physio_qa(TR,zdim)
% script reads in physio and fit data in local directory and pestica/ subdirectory
% plot histograms of periodicities, plot IRFs, report number of voxels significantly coupled
if ((exist('TR')==0) || (exist('zdim')==0))
  disp('must give TR and number of slices');
  return
end
if (zdim>200)
  disp('check your order of parameters, number of slices is awfully high');
  zdim
  return
end
if (TR>30)
  TR=TR/1000.0;
end
disp(sprintf('using %d slices, TR=%f seconds',zdim,TR));
f_s=zdim/TR;

load cardphase.dat
load respphase.dat
[card_peaks,card_avg_period,cardph,cardphm]=get_phase_period(cardphase,'card');
[resp_peaks,resp_avg_period,respph,respphm]=get_phase_period(respphase,'resp');
load pestica/impulse_responses_firstpass.mat
disp('FIRST PASS (no adjustment of cardiac phase data)');
disp(sprintf('Mean Cardiac Rate: %f, Mean Respiratory Rate: %f',f_s/card_avg_period,f_s/resp_avg_period));
disp(sprintf('%d voxels coupled to cardiac\n%d voxels coupled to respiration\n',length(find(cmask==1)), length(find(rmask==1))));

figure
subplot(2,1,1);
hist(60*f_s./(card_peaks(2:end)-card_peaks(1:end-1)),15)
set(gca,'fontsize',16)
ylabel('Count');
xlabel('Beats per Minute');
subplot(2,1,2);
hist(60*f_s./(resp_peaks(2:end)-resp_peaks(1:end-1)),15)
set(gca,'fontsize',16)
ylabel('Count');
xlabel('Breaths per Minute');
saveas(gcf,'pestica_qa_hists_firstpass.jpg');

figure
subplot(2,1,1);
plot(irf_card(1:4,:)','linewidth',2)
set(gca,'fontsize',16)
ylabel('A.U.'); % Arbitrary Units
xlabel('Relative % Phase in Cycle');
subplot(2,1,2);
plot(irf_resp(1:2,:)','linewidth',2)
set(gca,'fontsize',16)
ylabel('A.U.');
xlabel('Relative % Phase in Cycle');
saveas(gcf,'pestica_qa_irf_firstpass.jpg');

load physio_fitted.mat
[card_peaks,card_avg_period,cardph,cardphm]=get_phase_period(cardphase,'card');
load pestica/impulse_responses_secondpass.mat
disp('SECOND PASS (cardiac phase data adjusted for optimal fit to data)');
%disp(sprintf('Mean Cardiac Rate: %f\n',f_s/card_avg_period));
disp(sprintf('%d voxels coupled to cardiac\n%d voxels coupled to respiration\n',length(find(cmask==1)), length(find(rmask==1))));

figure
subplot(2,1,1);
hist(60*f_s./(card_peaks(2:end)-card_peaks(1:end-1)),15)
set(gca,'fontsize',16)
ylabel('Count');
xlabel('Beats per Minute');
subplot(2,1,2);
hist(60*f_s./(resp_peaks(2:end)-resp_peaks(1:end-1)),15)
set(gca,'fontsize',16)
ylabel('Count');
xlabel('Breaths per Minute');
saveas(gcf,'pestica_qa_hists_secondpass.jpg');

figure
subplot(2,1,1);
plot(irf_card(1:4,:)','linewidth',2)
set(gca,'fontsize',16)
ylabel('A.U.'); % Arbitrary Units
xlabel('Relative % Phase in Cycle');
subplot(2,1,2);
plot(irf_resp(1:2,:)','linewidth',2)
set(gca,'fontsize',16)
ylabel('A.U.');
xlabel('Relative % Phase in Cycle');
saveas(gcf,'pestica_qa_irf_secondpass.jpg');

