function prepare_ICA_decomp(comps,ep2d_filename,mask_filename,tdim_skip,ext_option)
%
% function prepare_ICA_decomp(comps,ep2d_filename,mask_filename,tdim_skip,ext_option)
%
% comps=give the number of components in the decomposition (10-15 are robust for 4mm and 2mm voxels)
% ep2d_filename=NIFTI or AFNI format file containing 4D ep2d data
% OPTIONAL mask_filename=NIFTI or AFNI format containing 3D mask data for ep2d_filename
% OPTIONAL tdim_skip=numbers of initial volumes to skip (default 0) to avoid initial SSFP effect
% OPTIONAL ext_option=1 or 0 to switch on or off extended infomax algorithm
%
% this function assumes that the input data specified by ep2d_filename is a 4D
% ep2d timeseries fMRI data with slice as the 3rd dimension and volume
% as the fourth dimension.  If this is not correct, permute your dataset
% so this assumption is correct (the IC's are only used to compute physiologic
% noise, which requires the slice as 3rd dim and the data are ep2d)
%
% size of imaging matrix may become problematic, as 128x128 matrix slices are 
% very time-consuming and MATLAB may run out of memory (TODO: modify to use memory mapping)

mnidir=getenv('PESTICA_DIR');
mat_afnidir=getenv('MATLAB_AFNI_DIR');
if (length(mnidir)==0)
  disp('you must have setup and sourced setup_pestica.sh before starting matlab');
  return
end
warning off
addpath(sprintf('%s/eeglab',mnidir));
addpath(mat_afnidir);
warning on

if (exist('comps')==0 | exist('ep2d_filename')==0)
  disp('must input two parameters: number of components, and filename of EPI data');
  disp('     third optional paramter = ANALYZE format 3D mask file for EPI data');
  disp('     fourth optional paramter = 1 for extended form of infomax ICA');
  return;
end
% use afni_matlab toolbox
Opt.Format = 'matrix';
[err, ima, ainfo, ErrMessage]=BrikLoad(ep2d_filename, Opt);
xdim=ainfo.DATASET_DIMENSIONS(1);
ydim=ainfo.DATASET_DIMENSIONS(2);
zdim=ainfo.DATASET_DIMENSIONS(3);
tdim=ainfo.DATASET_RANK(2);
if (tdim<50)
  disp('small temporal dimension, not recommended');
end
if (exist('ext_option')==0)
  ext_option=0;
end
[err,mask,minfo,ErrMessage]=BrikLoad(mask_filename, Opt);
mask(find(mask~=0))=1;
ima=reshape(ima,[xdim*ydim zdim tdim]);
mask=reshape(mask,[xdim*ydim zdim]);
if (exist('tdim_skip')==0)
  tdim_skip=0;
end
ima=ima(:,:,tdim_skip+1:end);
tdim=tdim-tdim_skip;

homedir=pwd;
%if (exist('pestica')~=7)
  system('mkdir pestica');
%end
cd pestica
for z=1:zdim
  % test for existence of ICA-decomposed .mat file
  if (exist(sprintf('pestica_%dcomps_slice%d.mat',comps,z))==2)
    % load and re-save in case the 's' matrix has been saved - we don't need this and it wastes a lot of space
    load(sprintf('pestica_%dcomps_slice%d.mat',comps,z));
    save(sprintf('pestica_%dcomps_slice%d.mat',comps,z),'z','w','A','m');
    continue
  end
  slicedata=double(reshape(squeeze(ima(:,z,:)),[xdim*ydim tdim]));
  % reduce dimensionality with mask(:,:,z), save a matrix for converting back at the end
  q=0;
  clear reduced_slicedata convertback;
  indices=find(mask(:,z)==1);
  reduced_slicedata=slicedata(indices,:);
  if (length(indices)<5*comps)
    disp(sprintf('none (or not enough: %d) tissue voxels on this slice, skipping...',q));
    continue;
  end
  % run temporal ICA on data, running PCA first and keeping 10 principal components to pass to ICA
  % running linear detrend first, removing mean also
  reduced_slicedata=detrend(reduced_slicedata')';
  if (ext_option==0)
    [w,s]=runica(reduced_slicedata,'pca',comps,'verbose','off');
  else
    [w,s]=runica(reduced_slicedata,'pca',comps,'extended',1,'verbose','off');
  end
  u=w*s;
  m=pinv(u);
  A=u*reduced_slicedata;
  % convert back to full spatial dimension
  converted_m=zeros(size(slicedata,1),size(m,2));
  converted_m(indices,:)=m;
  disp(sprintf('done with slice %d',z));
  m=converted_m;
  save(sprintf('pestica_%dcomps_slice%d.mat',comps,z),'z','w','A','m');
  %save(sprintf('pestica_%dcomps_slice%d.mat',comps,z),'z','w','s','A','m');
  clear w s A converted_m;
end
cd(homedir);

