#include <iostream>

#include "GAMBITCLP.h"
#include "GAMBITComputation.h"
#include "GAMBITParameters.h"

int main(int argc, char *argv[])
{
  PARSE_ARGS;

  std::cout<<"GAMBIT: Automatic Mesh Based cortIcal Thickness"<<std::endl;

  // Set parameters
  Parameters GAMBITParameters;
  GAMBITParameters.SetModulePath(argv[0]);
  // IO
  GAMBITParameters.SetInputGroupFile(InputGroupFile);
  GAMBITParameters.SetOutputDirectory(OutputDirectory);
  GAMBITParameters.SetDataSubdir(DataSubdir);
  // Tissue segmentation
  GAMBITParameters.SetTissueSegmentation(!TissueSegmentationOff);
  GAMBITParameters.SetSegAtlasDir(SegAtlasDir);
  GAMBITParameters.SetSegAtlasType(SegAtlasType);
  // Input file parameters
  GAMBITParameters.SetT1ManualSelection(T1ManualSelection);
  GAMBITParameters.SetT1ColumnNumber(T1ColumnNumber);
  GAMBITParameters.SetIsInputT2Image(IsInputT2Image);
  GAMBITParameters.SetT2ColumnNumber(T2ColumnNumber);
  GAMBITParameters.SetIsInputPDImage(IsInputPDImage);
  GAMBITParameters.SetPDColumnNumber(PDColumnNumber);
  GAMBITParameters.SetIsInputTissueLabelImage(IsInputTissueLabelImage);
  GAMBITParameters.SetTissueLabelColumnNumber(TissueLabelColumnNumber);  
  // Skull-stripping parameters
  GAMBITParameters.SetSkullStripping(!SkullStrippingOff);
  GAMBITParameters.SetMaskDilation(MaskDilation);
  // ROI Atlas registration
  GAMBITParameters.SetRegistrationType(RegistrationType);
  GAMBITParameters.SetROIAtlasImage(ROIAtlasImage);
  GAMBITParameters.SetAtlasAbsoluteWMMaskImage(AtlasAbsoluteWMMaskImage);
  GAMBITParameters.SetAtlasCSFToWMMaskImage(AtlasCSFToWMMaskImage);
  GAMBITParameters.SetAtlasRemoveGMMaskImage(AtlasRemoveGMMaskImage);
  GAMBITParameters.SetAtlasExclusionMaskImage(AtlasExclusionMaskImage);
  GAMBITParameters.SetAtlasParcellationImage(AtlasParcellationImage);
  GAMBITParameters.SetAtlasParticleInitializationImage(AtlasParticleInitializationImage);
  // Advanced tissue segmentation parameters
  GAMBITParameters.SetABCMaxBiasDegree(ABCMaxBiasDegree);
  GAMBITParameters.SetABCPriors(ABCPriors);
  GAMBITParameters.SetABCAtlasWarpIteration(ABCAtlasWarpIteration);
  GAMBITParameters.SetABCAtlasLinearMapType(ABCAtlasLinearMapType);
  GAMBITParameters.SetABCImageLinearMapType(ABCImageLinearMapType);
  // Advanced surface inflation parameters
  GAMBITParameters.SetInflationMaxIterationsBeforeFixing(InflationMaxIterationsBeforeFixing);
  GAMBITParameters.SetInflationMaxCurvature(InflationMaxCurvature);
  GAMBITParameters.SetInflationMaxIteration(InflationMaxIteration);
  GAMBITParameters.SetInflationMeanCurvature(InflationMeanCurvature);
  GAMBITParameters.SetInflationSmoothing(InflationSmoothing);
  // Advanced correspondence parameters
  GAMBITParameters.SetCorrespondencePreprocessingSmoothing(CorrespondencePreprocessingSmoothing);
  GAMBITParameters.SetCorrespondenceNbParticles(CorrespondenceNbParticles);
  GAMBITParameters.SetCorrespondenceIterationsPerSplit(CorrespondenceIterationsPerSplit);
  GAMBITParameters.SetCorrespondenceStartingRegularization(CorrespondenceStartingRegularization);
  GAMBITParameters.SetCorrespondenceEndingRegularization(CorrespondenceEndingRegularization);
  GAMBITParameters.SetCorrespondenceOptimizationIterations(CorrespondenceOptimizationIterations);
  GAMBITParameters.SetCorrespondenceCheckPointingIntervals(CorrespondenceCheckPointingIntervals);
  GAMBITParameters.SetCorrespondenceRelativeWeighting(CorrespondenceRelativeWeighting);
  GAMBITParameters.SetCorrespondenceProcrustesOff(CorrespondenceProcrustesOff);
  GAMBITParameters.SetCorrespondenceProcrustesInterval(CorrespondenceProcrustesInterval);
  GAMBITParameters.SetCorrespondenceProcrustesScalingOff(CorrespondenceProcrustesScalingOff);
  GAMBITParameters.SetCorrespondencePostProcessingProjectToSurfaceOff(CorrespondencePostProcessingProjectToSurfaceOff);
  GAMBITParameters.SetCorrespondencePostProcessingProjectionFactor(CorrespondencePostProcessingProjectionFactor);

  // Computation
  Computation GAMBITComputation(GAMBITParameters);
  GAMBITComputation.Compute();

  return EXIT_SUCCESS;
}
