#ifndef GAMBITCOMPUTATION_H
#define GAMBITCOMPUTATION_H

#include <bmScriptParser.h>
#include <BMString.h>

#include "GAMBITParameters.h"

class Computation
{
 public:
  Computation(Parameters _Parameters);
  ~Computation(){};

  void Compute();
  
 private:
  void ReadInputFile();  
  void SetInputHeaders(std::vector<std::string> _vInputHeaders){m_vInputHeaders = _vInputHeaders;};
  std::vector<std::string> GetInputHeaders(){return m_vInputHeaders;};
  void SetInputData(std::vector<std::vector<std::string> > _vInputData){m_vInputData = _vInputData;};
  std::string GetInputData(int i, int j){return m_vInputData[i][j];};
  void SetNbData(int _NbData){m_NbData = _NbData;};
  int GetNbData(){return m_NbData;};
  
  bool CheckImageFormat(std::string _FileName);
  void DisplayErrorAndExit(std::string _ImageModality, bool _ErrorNb);
  void CheckInputFileParameters();

  void SetBMSParameterFile();
  std::string GetBMSParameterFile(){return m_BMSParameterFile;};
  void WriteBMSParameterFile();

  void SetBMSComputationFile();
  std::string GetBMSComputationFile(){return m_BMSComputationFile;};
  void WriteBMSComputationFile();

  void SetBMSMRMLCreationFile();
  std::string GetBMSMRMLCreationFile(){return m_BMSMRMLCreationFile;};
  void WriteBMSMRMLCreationFile();
  
  void ExecuteBatchMakeScript(std::string _FileName);

  void Debug();

  Parameters *m_Parameters;
  std::string m_BMSParameterFile;
  std::string m_BMSComputationFile;
  std::string m_BMSMRMLCreationFile;
  
  std::vector<std::string> m_vInputHeaders;
  std::vector<std::vector<std::string> > m_vInputData;
  int m_NbData;
};
#endif
