#ifndef GAMBITPARAMETERS_H
#define GAMBITPARAMETERS_H

#include <iostream>
#include <fstream>
#include <vector>
#include <string>
#include <sstream>

class Parameters
{
  public:
  Parameters(){};
  ~Parameters(){};
  
  void SetModulePath(std::string _ModulePath);
  // IO
  void SetInputGroupFile(std::string _InputGroupFile){m_InputGroupFile = _InputGroupFile;};
  void SetOutputDirectory(std::string _OutputDirectory);
  void SetDataSubdir(std::string _DataSubdir){m_DataSubdir = _DataSubdir;};
  // Tissue segmentation
  void SetTissueSegmentation(bool _IsTissueSegmentation){m_IsTissueSegmentation = _IsTissueSegmentation;};
  void SetSegAtlasDir(std::string _SegAtlasDir){m_SegAtlasDir = _SegAtlasDir;};
  void SetSegAtlasType(std::string _SegAtlasType){m_SegAtlasType = _SegAtlasType;};
  // Input file parameters
  void SetT1ManualSelection(bool _T1ManualSelection){m_T1ManualSelection = _T1ManualSelection;};
  void SetT1ColumnNumber(int _T1ColumnNumber){m_T1ColumnNumber = _T1ColumnNumber;};
  void SetIsInputT2Image(bool _IsInputT2Image){m_IsInputT2Image = _IsInputT2Image;};
  void SetT2ColumnNumber(int _T2ColumnNumber){m_T2ColumnNumber = _T2ColumnNumber;};
  void SetIsInputPDImage(bool _IsInputPDImage){m_IsInputPDImage = _IsInputPDImage;};
  void SetPDColumnNumber(int _PDColumnNumber){m_PDColumnNumber = _PDColumnNumber;};
  void SetIsInputTissueLabelImage(bool _IsInputTissueLabelImage){m_IsInputTissueLabelImage = _IsInputTissueLabelImage;};
  void SetTissueLabelColumnNumber(int _TissueLabelColumnNumber){m_TissueLabelColumnNumber = _TissueLabelColumnNumber;};
  // Skull-stripping
  void SetSkullStripping(bool _IsSkullStripping){m_IsSkullStripping = _IsSkullStripping;};
  void SetMaskDilation(bool _MaskDilation){m_MaskDilation = _MaskDilation;};
  // Atlas registration
  void SetRegistrationType(std::string _RegistrationType){m_RegistrationType = _RegistrationType;};
  void SetROIAtlasImage(std::string _ROIAtlasImage){m_ROIAtlasImage = _ROIAtlasImage;};
  void SetAtlasAbsoluteWMMaskImage(std::string _AtlasAbsoluteWMMaskImage){m_AtlasAbsoluteWMMaskImage = _AtlasAbsoluteWMMaskImage;};
  void SetAtlasCSFToWMMaskImage(std::string _AtlasCSFToWMMaskImage){m_AtlasCSFToWMMaskImage = _AtlasCSFToWMMaskImage;};
  void SetAtlasRemoveGMMaskImage(std::string _AtlasRemoveGMMaskImage){m_AtlasRemoveGMMaskImage = _AtlasRemoveGMMaskImage;};
  void SetAtlasExclusionMaskImage(std::string _AtlasExclusionMaskImage){m_AtlasExclusionMaskImage = _AtlasExclusionMaskImage;};
  void SetAtlasParcellationImage(std::string _AtlasParcellationImage){m_AtlasParcellationImage = _AtlasParcellationImage;};
  void SetAtlasParticleInitializationImage(std::string _AtlasParticleInitializationImage){m_AtlasParticleInitializationImage = _AtlasParticleInitializationImage;};
  // Advanced tissue segmentation parameters
  void SetABCMaxBiasDegree(int _ABCMaxBiasDegree){m_ABCMaxBiasDegree = _ABCMaxBiasDegree;};
  //void SetABCPriors(std::vector<float> _ABCPriors){m_vABCPriors = _ABCPriors;};
  void SetABCPriors(std::string _ABCPriors){m_vABCPriors = _ABCPriors;};
  void SetABCAtlasWarpIteration(int _ABCAtlasWarpIteration){m_ABCAtlasWarpIteration = _ABCAtlasWarpIteration;};
  void SetABCAtlasLinearMapType(std::string _ABCAtlasLinearMapType){m_ABCAtlasLinearMapType = _ABCAtlasLinearMapType;};
  void SetABCImageLinearMapType(std::string _ABCImageLinearMapType){m_ABCImageLinearMapType = _ABCImageLinearMapType;};
  // Advanced surface inflation parameters
  void SetInflationMaxIterationsBeforeFixing(int _InflationMaxIterationsBeforeFixing){m_InflationMaxIterationsBeforeFixing = _InflationMaxIterationsBeforeFixing;};
  void SetInflationMaxCurvature(float _InflationMaxCurvature){m_InflationMaxCurvature = _InflationMaxCurvature;};
  void SetInflationMaxIteration(int _InflationMaxIteration){m_InflationMaxIteration = _InflationMaxIteration;};
  void SetInflationMeanCurvature(float _InflationMeanCurvature){m_InflationMeanCurvature = _InflationMeanCurvature;};
  void SetInflationSmoothing(float _InflationSmoothing){m_InflationSmoothing = _InflationSmoothing;};  
  // Advanced correspondence parameters
  void SetCorrespondencePreprocessingSmoothing(int _CorrespondencePreprocessingSmoothing){m_CorrespondencePreprocessingSmoothing = _CorrespondencePreprocessingSmoothing;};
  void SetCorrespondenceNbParticles(int _CorrespondenceNbParticles){m_CorrespondenceNbParticles = _CorrespondenceNbParticles;};
  void SetCorrespondenceIterationsPerSplit(int _CorrespondenceIterationsPerSplit){m_CorrespondenceIterationsPerSplit = _CorrespondenceIterationsPerSplit;};
  void SetCorrespondenceStartingRegularization(float _CorrespondenceStartingRegularization){m_CorrespondenceStartingRegularization = _CorrespondenceStartingRegularization;};
  void SetCorrespondenceEndingRegularization(float _CorrespondenceEndingRegularization){m_CorrespondenceEndingRegularization = _CorrespondenceEndingRegularization;};
  void SetCorrespondenceOptimizationIterations(int _CorrespondenceOptimizationIterations){m_CorrespondenceOptimizationIterations = _CorrespondenceOptimizationIterations;};
  void SetCorrespondenceCheckPointingIntervals(int _CorrespondenceCheckPointingIntervals){m_CorrespondenceCheckPointingIntervals = _CorrespondenceCheckPointingIntervals;};
  void SetCorrespondenceRelativeWeighting(float _CorrespondenceRelativeWeighting){m_CorrespondenceRelativeWeighting = _CorrespondenceRelativeWeighting;};
  void SetCorrespondenceProcrustesOff(int _CorrespondenceProcrustesOff){m_CorrespondenceProcrustesOff = _CorrespondenceProcrustesOff;};
  void SetCorrespondenceProcrustesInterval(int _CorrespondenceProcrustesInterval){m_CorrespondenceProcrustesInterval = _CorrespondenceProcrustesInterval;};
  void SetCorrespondenceProcrustesScalingOff(bool _CorrespondenceProcrustesScalingOff){m_CorrespondenceProcrustesScalingOff = _CorrespondenceProcrustesScalingOff;};
  void SetCorrespondencePostProcessingProjectToSurfaceOff(bool _CorrespondencePostProcessingProjectToSurfaceOff){m_CorrespondencePostProcessingProjectToSurfaceOff = _CorrespondencePostProcessingProjectToSurfaceOff;};
  void SetCorrespondencePostProcessingProjectionFactor(float _CorrespondencePostProcessingProjectionFactor){m_CorrespondencePostProcessingProjectionFactor = _CorrespondencePostProcessingProjectionFactor;};

  std::string GetModulePath(){return m_ModulePath;};
  // IO
  std::string GetInputGroupFile(){return m_InputGroupFile;};
  std::string GetOutputDirectory(){return m_OutputDirectory;};
  std::string GetDataSubdir(){return m_DataSubdir;};
  // Tissue segmentation
  bool GetTissueSegmentation(){return m_IsTissueSegmentation;};
  std::string GetSegAtlasDir(){return m_SegAtlasDir;};
  std::string GetSegAtlasType(){return m_SegAtlasType;};
  // Skull-stripping
  bool GetSkullStripping(){return m_IsSkullStripping;};
  bool GetMaskDilation(){return m_MaskDilation;};
  // Atlas registration
  std::string GetRegistrationType(){return m_RegistrationType;};
  std::string GetROIAtlasImage(){return m_ROIAtlasImage;};
  std::string GetAtlasAbsoluteWMMaskImage(){return m_AtlasAbsoluteWMMaskImage;};
  std::string GetAtlasCSFToWMMaskImage(){return m_AtlasCSFToWMMaskImage;};
  std::string GetAtlasRemoveGMMaskImage(){return m_AtlasRemoveGMMaskImage;};
  std::string GetAtlasExclusionMaskImage(){return m_AtlasExclusionMaskImage;};
  std::string GetAtlasParcellationImage(){return m_AtlasParcellationImage;};
  std::string GetAtlasParticleInitializationImage(){return m_AtlasParticleInitializationImage;};
  // Advanced input file parameters
  bool GetT1ManualSelection(){return m_T1ManualSelection;};
  int GetT1ColumnNumber(){return m_T1ColumnNumber;};
  bool GetIsInputT2Image(){return m_IsInputT2Image;};
  int GetT2ColumnNumber(){return m_T2ColumnNumber;};
  bool GetIsInputPDImage(){return m_IsInputPDImage;};
  int GetPDColumnNumber(){return m_PDColumnNumber;};
  bool GetIsInputTissueLabelImage(){return m_IsInputTissueLabelImage;};
  int GetTissueLabelColumnNumber(){return m_TissueLabelColumnNumber;};
  // Advanced tissue segmentation parameters
  int GetABCMaxBiasDegree(){return m_ABCMaxBiasDegree;};
  //std::vector<float> GetABCPriors(){return m_vABCPriors;};
  std::string GetABCPriors(){return m_vABCPriors;};
  int GetABCAtlasWarpIteration(){return m_ABCAtlasWarpIteration;};
  std::string GetABCAtlasLinearMapType(){return m_ABCAtlasLinearMapType;};
  std::string GetABCImageLinearMapType(){return m_ABCImageLinearMapType;};
  // Advanced surface inflation parameters
  int GetInflationMaxIterationsBeforeFixing(){return m_InflationMaxIterationsBeforeFixing;};
  float GetInflationMaxCurvature(){return m_InflationMaxCurvature;};
  int GetInflationMaxIteration(){return m_InflationMaxIteration;};
  float GetInflationMeanCurvature(){return m_InflationMeanCurvature;};
  float GetInflationSmoothing(){return m_InflationSmoothing;};
  // Advanced correspondence parameters
  int GetCorrespondencePreprocessingSmoothing(){return m_CorrespondencePreprocessingSmoothing;};
  int GetCorrespondenceNbParticles(){return m_CorrespondenceNbParticles;};
  int GetCorrespondenceIterationsPerSplit(){return m_CorrespondenceIterationsPerSplit;};
  float GetCorrespondenceStartingRegularization(){return m_CorrespondenceStartingRegularization;};
  float GetCorrespondenceEndingRegularization(){return m_CorrespondenceEndingRegularization;};
  int GetCorrespondenceOptimizationIterations(){return m_CorrespondenceOptimizationIterations;};
  int GetCorrespondenceCheckPointingIntervals(){return m_CorrespondenceCheckPointingIntervals;};
  float GetCorrespondenceRelativeWeighting(){return m_CorrespondenceRelativeWeighting;};
  bool GetCorrespondenceProcrustesOff(){return m_CorrespondenceProcrustesOff;};
  int GetCorrespondenceProcrustesInterval(){return m_CorrespondenceProcrustesInterval;};
  bool GetCorrespondenceProcrustesScalingOff(){return m_CorrespondenceProcrustesScalingOff;};
  bool GetCorrespondencePostProcessingProjectToSurfaceOff(){return m_CorrespondencePostProcessingProjectToSurfaceOff;};
  float GetCorrespondencePostProcessingProjectionFactor(){return m_CorrespondencePostProcessingProjectionFactor;};

 private:
  std::string m_ModulePath;
  // IO
  std::string m_InputGroupFile;
  std::string m_OutputDirectory;
  std::string m_DataSubdir;
  // Tissue segmentation
  bool m_IsTissueSegmentation;
  std::string m_SegAtlasDir;
  std::string m_SegAtlasType;
  // Skull-stripping
  bool m_IsSkullStripping;
  bool m_MaskDilation;
  // Atlas registration
  std::string m_RegistrationType;
  std::string m_ROIAtlasImage;
  std::string m_AtlasAbsoluteWMMaskImage;
  std::string m_AtlasCSFToWMMaskImage;
  std::string m_AtlasRemoveGMMaskImage;
  std::string m_AtlasExclusionMaskImage;
  std::string m_AtlasParcellationImage;
  std::string m_AtlasParticleInitializationImage;
  // Advanced input file parameters
  bool m_T1ManualSelection;
  int m_T1ColumnNumber;
  bool m_IsInputT2Image;
  int m_T2ColumnNumber;
  bool m_IsInputPDImage;
  int m_PDColumnNumber;
  bool m_IsInputTissueLabelImage;
  int m_TissueLabelColumnNumber;
  // Advanced tissue segmentation parameters
  int m_ABCMaxBiasDegree;
  //std::vector<float> m_vABCPriors;
  std::string m_vABCPriors;
  int m_ABCAtlasWarpIteration;
  std::string m_ABCAtlasLinearMapType;
  std::string m_ABCImageLinearMapType;
  // Advanced surface inflation parameters
  int m_InflationMaxIterationsBeforeFixing;
  float m_InflationMaxCurvature;
  int m_InflationMaxIteration;
  float m_InflationMeanCurvature;
  float m_InflationSmoothing;
  // Advanced correspondence parameters
  int m_CorrespondencePreprocessingSmoothing;
  int m_CorrespondenceNbParticles;
  int m_CorrespondenceIterationsPerSplit;
  float m_CorrespondenceStartingRegularization;
  float m_CorrespondenceEndingRegularization;
  int m_CorrespondenceOptimizationIterations;
  int m_CorrespondenceCheckPointingIntervals;
  float m_CorrespondenceRelativeWeighting;
  bool m_CorrespondenceProcrustesOff;
  int m_CorrespondenceProcrustesInterval;
  bool m_CorrespondenceProcrustesScalingOff;
  bool m_CorrespondencePostProcessingProjectToSurfaceOff;
  float m_CorrespondencePostProcessingProjectionFactor;
};
#endif
