/*=========================================================================
  Program:   LabelSegPostProcess
  Module:    $RCSfile: Computation.h,v $
  Language:  C++
  Date:      $Date: 2011/04/15 20:05:39 $
  Version:   $Revision: 1.0 $
  Author:    Clement Vachet (cvachet@unc.edu)

  Copyright (c) Clement Vachet. All rights reserved.
  See NeuroLibCopyright.txt or http://www.ia.unc.edu/dev/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef COMPUTATION_H
#define COMPUTATION_H

#include <iostream>
#include <string>

// ITK
#include <itkImage.h>
#include <itkImageFileReader.h> 
#include <itkImageFileWriter.h>
#include <itkImageRegionIterator.h>
#include <itkConnectedComponentImageFilter.h>
#include <itkRelabelComponentImageFilter.h>
#include <itkThresholdImageFilter.h> 
#include <itkBinaryThresholdImageFilter.h> 
#include <itkNeighborhoodIterator.h>
#include <itkImageRegionIterator.h>
#include <itkImageRegionConstIterator.h>
#include <itkSubtractImageFilter.h>

#include <itkBinaryBallStructuringElement.h> 
#include <itkBinaryDilateImageFilter.h> 
#include <itkMaskImageFilter.h>


using namespace itk;

const int Dimension = 3;
typedef unsigned short ImagePixelType;

typedef Image<ImagePixelType,Dimension>  ImageType;

typedef ImageFileReader<ImageType> VolumeReaderType;
typedef ImageFileWriter<ImageType> VolumeWriterType;
typedef ConnectedComponentImageFilter<ImageType,ImageType> ConnectiveFilterType;
typedef RelabelComponentImageFilter<ImageType,ImageType> RelabelFilterType;
typedef ThresholdImageFilter< ImageType > maskThreshFilterType;
typedef BinaryThresholdImageFilter<ImageType,ImageType> threshFilterType;
typedef ImageRegionIterator<ImageType> IteratorType;
typedef NeighborhoodIterator<ImageType> NeighborhoodIteratorType;
typedef ImageRegionIterator<ImageType> IteratorType;
typedef ImageRegionConstIterator<ImageType> ConstIteratorType;
typedef SubtractImageFilter<ImageType,ImageType,ImageType> subFilterType;

typedef BinaryBallStructuringElement<ImagePixelType,Dimension> StructuringElementType;
typedef BinaryDilateImageFilter<ImageType, ImageType, StructuringElementType> dilateFilterType;
typedef MaskImageFilter< ImageType, ImageType, ImageType >  maskFilterType;


class Computation
{
 public:
  Computation(){};
  ~Computation(){};

  // IO
  void SetInputLabel(std::string _InputLabelName){m_InputLabelName = _InputLabelName;};
  void SetOutputLabel(std::string _OutputLabelName){m_OutputLabelName = _OutputLabelName;};
  void SetAbsoluteWMMaskImage(std::string _AbsoluteWMMaskImageName){m_AbsoluteWMMaskImageName = _AbsoluteWMMaskImageName;};
  void SetRemoveGMMaskImage(std::string _RemoveGMMaskImageName){m_RemoveGMMaskImageName = _RemoveGMMaskImageName;};
  void SetExclusionMaskImage(std::string _ExclusionMaskImageName){m_ExclusionMaskImageName = _ExclusionMaskImageName;};
  // Tissue Labels
  void SetWMLabel(unsigned int _WMLabel){m_WMLabel = _WMLabel;};
  void SetGMLabel(unsigned int _GMLabel){m_GMLabel = _GMLabel;};
  void SetCSFLabel(unsigned int _CSFLabel){m_CSFLabel = _CSFLabel;};
  // Optional output images
  void SetOutputWM(std::string _OutputWMName){m_OutputWMName = _OutputWMName;};
  void SetOutputGM(std::string _OutputGMName){m_OutputGMName = _OutputGMName;};
  void SetOutputCSF(std::string _OutputCSFName){m_OutputCSFName = _OutputCSFName;};
  // Advanced Parameters
  void SetDilationOn(bool _DilationOn){m_DilationOn = _DilationOn;};
  void SetDebugOn(bool _DebugOn){m_DebugOn = _DebugOn;};

  void ReadInputImages();
  void Compute();
  
 private:
  // IO
  std::string GetInputLabel(){return m_InputLabelName;};
  std::string GetOutputLabel(){return m_OutputLabelName;};
  // Tissue labels
  unsigned int GetWMLabel(){return m_WMLabel;};
  unsigned int GetGMLabel(){return m_GMLabel;};
  unsigned int GetCSFLabel(){return m_CSFLabel;};
  // Optional output images
  std::string GetOutputWM(){return m_OutputWMName;};
  std::string GetOutputGM(){return m_OutputGMName;};
  std::string GetOutputCSF(){return m_OutputCSFName;};
  // Advanced parameters
  bool DilationOn(){return m_DilationOn;};
  bool DebugOn(){return m_DebugOn;};

  //Computation
  void ExtractTissueLabels();
  void CreateWMMap();
  void CreateGMMap();
  void ComputeNewAddGM();
  void CreateFinalLabelMap();

  // Advanced Computation
  void ReadImage(std::string _FileName, ImageType::Pointer &_outputImage);
  void WriteImage(std::string _FileName, ImageType::Pointer _Image);
  void ExtractLabel(ImageType::Pointer _inputImage, unsigned int _Label, ImageType::Pointer &_outputImage);
  void Dilation(ImageType::Pointer _inputImage, ImageType::Pointer &_outputImage);
  void Combine(ImageType::Pointer _inputImage1, ImageType::Pointer _inputImage2, ImageType::Pointer &_outputImage);
  void Subtract(ImageType::Pointer _inputImage1, ImageType::Pointer _inputImage2, ImageType::Pointer &_outputImage);
  void ThreshMask(ImageType::Pointer _inputImage, ImageType::Pointer &_outputImage);
  void InsideFilling(ImageType::Pointer _inputImage, ImageType::Pointer &_outputImage);
  void ComputeLargestComponent(ImageType::Pointer _inputImage, ImageType::Pointer &_outputImage);
  void Mask(ImageType::Pointer _inputImage1, ImageType::Pointer _inputImage2, ImageType::Pointer &_outputImage);
  void Multiply(ImageType::Pointer _inputImage, ImagePixelType value);

  // IO
  std::string m_InputLabelName, m_OutputLabelName;
  std::string m_AbsoluteWMMaskImageName, m_RemoveGMMaskImageName, m_ExclusionMaskImageName;
  // Tissue labels
  unsigned int m_WMLabel, m_GMLabel, m_CSFLabel;
  // Optional output images
  std::string m_OutputWMName, m_OutputGMName, m_OutputCSFName;
  // Advanced parameters
  bool m_DilationOn, m_DebugOn;

  ImageType::Pointer m_inputLabelImage, m_outputLabelImage;
  ImageType::Pointer m_AbsoluteWMMaskImage, m_RemoveGMMaskImage, m_ExclusionMaskImage;
  ImageType::Pointer m_WMLabelImage, m_GMLabelImage, m_CSFLabelImage;
  ImageType::Pointer m_newAddGMImage;

};

#endif
