/*=========================================================================
  Program:   LabelSegPostProcess
  Module:    $RCSfile: LabelSegPostProcess.cxx,v $
  Language:  C++
  Date:      $Date: 2011/04/15 19:58:44 $
  Version:   $Revision: 1.0 $
  Author:    Clement Vachet (cvachet@unc.edu)

  Copyright (c) Clement Vachet. All rights reserved.
  See NeuroLibCopyright.txt or http://www.ia.unc.edu/dev/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#include <iostream>

#include "LabelSegPostProcessCLP.h"
#include "Computation.h"

int main(int argc, char *argv[])
{
  PARSE_ARGS;

  Computation m_Computation;
  // IO
  m_Computation.SetInputLabel(InputLabel);
  m_Computation.SetOutputLabel(OutputLabel);
  m_Computation.SetAbsoluteWMMaskImage(AbsoluteWMMaskImage);
  m_Computation.SetRemoveGMMaskImage(RemoveGMMaskImage);
  m_Computation.SetExclusionMaskImage(ExclusionMaskImage);
  // Tissue labels
  m_Computation.SetWMLabel(WMLabel);
  m_Computation.SetGMLabel(GMLabel);
  m_Computation.SetCSFLabel(CSFLabel);
  // Optional output images
  m_Computation.SetOutputWM(OutputWM);
  m_Computation.SetOutputGM(OutputGM);
  m_Computation.SetOutputCSF(OutputCSF);
  // Advanced Parameters
  m_Computation.SetDilationOn(!NoDilation);
  m_Computation.SetDebugOn(Debug);

  m_Computation.ReadInputImages();
  m_Computation.Compute();

  return EXIT_SUCCESS;
}
