#include "DanielssonInterpolator.h"

void DanielssonInterpolator::SetInput_VectorMap(const char* FileName)
{
	//Load VectorMap
	DilateThickness();
	ReaderVectorType::Pointer reader = ReaderVectorType::New();
	try
  	{
    		reader->SetFileName(FileName) ;
    		reader->Update() ;
    		VectorImage = reader->GetOutput() ;
  	}
  	catch( itk::ExceptionObject exp )
  	{
		std::cerr << "Exception caughinterpolatort !" << std::endl;
        	std::cerr <<     exp    << std::endl;
  	}
}

void DanielssonInterpolator::CalculVectorImage(const char* FileName,const char* DanFileName, bool write)
{
	//Calcul VectorMap
	//DilateThickness();
	std::cout<<" Calcul VectorMap "<<std::endl;
	FilterType::Pointer filter = FilterType::New();
	filter->SetInput(ImageForDan);
	filter->SetUseImageSpacing(true);
	filter->Update();
	DanielssonImage = filter->GetDistanceMap();
	VectorImage = OffsetImageType::New();
	VectorImage = filter->GetVectorDistanceMap();

	if(write)
	{
		//WriteVectorMap
		WriterVectorType::Pointer writer = WriterVectorType::New();
		WriterType::Pointer danwriter = WriterType::New();
		try
  		{
    			writer->SetFileName(FileName) ;
			danwriter->SetFileName(DanFileName);
			writer->SetInput(VectorImage);
			danwriter->SetInput(DanielssonImage);
    			writer->Update() ;
			danwriter->Update() ;
  		}
  		catch( itk::ExceptionObject exp )
  		{
			std::cerr << "Exception caughinterpolatort !" << std::endl;
        		std::cerr <<     exp    << std::endl;
  		}
	}
}

float DanielssonInterpolator::Evaluate(PointType Pts)
{
	const ImageType::SpacingType& sp = InputImage->GetSpacing();
	ImageType::IndexType Index;
	Index[0] =(int)( Pts[0]/sp[0]);
	Index[1] =(int)( Pts[1]/sp[1]);
	Index[2] =(int)( Pts[2]/sp[2]);
	float Distance = 0;
	Distance = InputImage->GetPixel(Index);
	//If Distance > 0, Keep it
	if(Distance > 0)
		return Distance;
	//Else Find the nearest one
	else
	{
		Index[0] = Index[0] + VectorImage->GetPixel(Index)[0];
		Index[1] = Index[1] + VectorImage->GetPixel(Index)[1];
		Index[2] = Index[2] + VectorImage->GetPixel(Index)[2];
		Distance = InputImage->GetPixel(Index);
		return Distance;
	}
}

void DanielssonInterpolator::DilateThickness()
{
	std::cout<<" Dilate Thickness "<<std::endl;
	//First Dilate IMage with GrayscaleDilateImageFilter	
	// Create the filter
  	DilateFilterType::Pointer filter = DilateFilterType::New();
	// Create the structuring element
  	myKernelType ball;
  	myKernelType::SizeType ballSize;
  	ballSize[0] = 1;
  	ballSize[1] = 1;
	ballSize[2] = 1;
  	ball.SetRadius(ballSize);
  	ball.CreateStructuringElement();

	ImagePointer Image;
	Image = CreateNewImageLike(InputImage);
	IteratorType InputIt(InputImage, InputImage->GetRequestedRegion() );
	for(InputIt.GoToBegin(); !InputIt.IsAtEnd();++InputIt)
	{	
		Image->SetPixel(InputIt.GetIndex(),InputIt.Get());	
	}
	
  	filter->SetInput( Image );
  	filter->SetKernel( ball );
	ThickerImage = CreateNewImageLike(InputImage);
	ThickerImage= filter->GetOutput();
	filter->Update();
}

//Create an image with the same properties as the parameter image
DanielssonInterpolator::ImagePointer DanielssonInterpolator::CreateNewImageLike(ImagePointer OriginalImage)
{
  ImagePointer outputImage = ImageType::New();
  outputImage->SetRegions( OriginalImage->GetRequestedRegion() );
  outputImage->CopyInformation( OriginalImage );
  outputImage->Allocate();
  return outputImage;
}
