
#ifndef DanielssonInterpolator_H
#define DanielssonInterpolator_H

#include "itkSignedDanielssonDistanceMapImageFilter.h"
#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include <itkPoint.h>
#include "itkImageRegionIteratorWithIndex.h"
#include <itkVector.h>
#include <itkGrayscaleDilateImageFilter.h>
#include <itkBinaryBallStructuringElement.h>

class DanielssonInterpolator
{
public:
	DanielssonInterpolator(){}
	virtual ~DanielssonInterpolator(){}
private:
	typedef float PixelType;
        
	typedef itk::Point< PixelType, 3> PointType;
	typedef itk::Vector< PixelType, 3> VectorType;

	typedef itk::Image< PixelType, 3 > ImageType;
	typedef itk::Image< VectorType, 3 > ImageVectorType;
	typedef itk::ImageFileWriter< ImageType  >  WriterType;

	typedef ImageType::Pointer ImagePointer;
	typedef ImageVectorType::Pointer ImageVectorPointer;
	
	typedef itk::SignedDanielssonDistanceMapImageFilter<ImageType,ImageType >  FilterType;
	typedef FilterType::VectorImageType   OffsetImageType;
  	typedef OffsetImageType::Pointer OffsetImagePointer;
	typedef itk::ImageFileReader< OffsetImageType  >  ReaderVectorType;
	typedef itk::ImageFileWriter< OffsetImageType  >  WriterVectorType;

	typedef itk::ImageRegionIteratorWithIndex< ImageType > IteratorType;

	typedef itk::BinaryBallStructuringElement<PixelType, 3> myKernelType;
	typedef itk::GrayscaleDilateImageFilter<ImageType,  ImageType, myKernelType>  DilateFilterType;

	ImagePointer InputImage;
	ImagePointer DanielssonImage;
	ImagePointer ImageForDan;
	ImagePointer ThickerImage;
	OffsetImagePointer VectorImage;

public:
	void CalculVectorImage(const char* FileName,const char* DanFileName, bool write);
	float Evaluate(PointType Pts);
	void SetInput_VectorMap(const char* FileName);
	void SetInput(ImagePointer Image) { InputImage = Image;}
	void SetInput_Dan(ImagePointer Image) { ImageForDan = Image;}
	void DilateThickness();
	ImagePointer CreateNewImageLike(ImagePointer OriginalImage);

};

#endif
