#include "ThicknessSmoother.h"

void ThicknessSmoother::ThickSmoother()
{
	Threshhold_Image();

	//First Dilate IMage with GrayscaleDilateImageFilter	
	// Create the filter
  DilateFilterType::Pointer filter = DilateFilterType::New();
	// Create the structuring element
  myKernelType ball;
  myKernelType::SizeType ballSize;
  ballSize[0] = 1;
  ballSize[1] = 1;
  ballSize[2] = 1;
  ball.SetRadius(ballSize);
  ball.CreateStructuringElement();
	
	ImagePointer Image;
	Image = CreateNewImageLike(GetOutput());
	IteratorType InputIt(InputImage, InputImage->GetRequestedRegion() );
	for(InputIt.GoToBegin(); !InputIt.IsAtEnd();++InputIt)
	{	
		Image->SetPixel(InputIt.GetIndex(),InputIt.Get()*100);	
	}
	
  filter->SetInput( Image );
  filter->SetKernel( ball );
	DilateImage = CreateNewImageLike(GetOutput());
	DilateImage= filter->GetOutput();
	filter->Update();
    
	// Second, Smooth Dilate Value
	// gaussian smoothing
	gaussiFilterType::Pointer smoothFilter = gaussiFilterType::New();  
        smoothFilter->SetInput(DilateImage);
        
        if(VarT)
          smoothFilter->SetVariance(VarianceT);
        else
        {
          const ImageType::SpacingType& sp = DilateImage->GetSpacing();
          double sp_max=sp[0];
          for(int i=1;i<3;i++)
          {
            if(sp[i]>sp[i-1])
              sp_max = sp[i];
          }
          smoothFilter->SetVariance(0.3*sp_max);
        }

        smoothFilter->SetMaximumKernelWidth(1);
        smoothFilter->Update () ;
	SmoothImage = CreateNewImageLike(GetOutput());
	SmoothImage = smoothFilter->GetOutput();
	//Third, Create A Mask Image to keep the original thickness Value
	MaskImage = CreateNewImageLike(GetOutput());
	
	IteratorType MaskIt(MaskImage, MaskImage->GetRequestedRegion() );
	IteratorType ThreshholdIt(ThreshholdImage, ThreshholdImage->GetRequestedRegion() );

	for(InputIt.GoToBegin(), MaskIt.GoToBegin(), ThreshholdIt.GoToBegin();
		!InputIt.IsAtEnd(), !MaskIt.IsAtEnd(), !ThreshholdIt.IsAtEnd();
			++InputIt, ++MaskIt, ++ThreshholdIt)
	{
		//for each point of Mask Image, MaskImage = ThreshholdImage * SmoothImage
		MaskIt.Set((ThreshholdIt.Get()*SmoothImage->GetPixel(InputIt.GetIndex()))/100);
		//Image = MaskImage + OriginalImage => Keep Original Thickness + add smooth Value of the original Thickness
		InputIt.Set(MaskIt.Get()+InputIt.Get());
	}
}

void ThicknessSmoother::Threshhold_Image()
{
	//Image with thickness Value
	ImagePointer ThickImage = ImageType::New();
	ThickImage = CreateNewImageLike(GetOutput());

	ThreshholdImage = CreateNewImageLike(GetOutput());

	IteratorType InputIt(InputImage, InputImage->GetRequestedRegion() );
	for(InputIt.GoToBegin(); !InputIt.IsAtEnd();++InputIt)
	{	
		//fill the thicknes Value
		ThickImage->SetPixel(InputIt.GetIndex(),InputIt.Get());		
	}

	IteratorType ThickIt(ThickImage, ThickImage->GetRequestedRegion() );
	IteratorType ThreshholdIt(ThreshholdImage, ThreshholdImage->GetRequestedRegion() );
	
	//fill theshhold Image  : = 1 when no thickness values, = 0 when thickness != 0 .
	for ( ThickIt.GoToBegin(), ThreshholdIt.GoToBegin(); 
		!ThickIt.IsAtEnd(), !ThreshholdIt.IsAtEnd(); ++ThickIt, ++ThreshholdIt)
	{
		if( ThickIt.Get()> 0)
		{ 
			ThreshholdIt.Set(0);
		}
		else ThreshholdIt.Set(1);
	}	
}

//Create an image with the same properties as the parameter image
ThicknessSmoother::ImagePointer ThicknessSmoother::CreateNewImageLike(ImagePointer OriginalImage)
{
  ImagePointer outputImage = ImageType::New();
  outputImage->SetRegions( OriginalImage->GetRequestedRegion() );
  outputImage->CopyInformation( OriginalImage );
  outputImage->Allocate();
  return outputImage;
}
