
#ifndef ThicknessSmoother_H
#define ThicknessSmoother_H

#include "itkImage.h"
#include <itkGaussianBlurImageFunction.h>
#include "itkImageRegionIteratorWithIndex.h"
#include <itkNeighborhoodIterator.h>
#include <itkDiscreteGaussianImageFilter.h>
#include <itkBinomialBlurImageFilter.h>
#include <itkGrayscaleDilateImageFilter.h>
#include <itkBinaryBallStructuringElement.h>

class ThicknessSmoother
{
public:
	ThicknessSmoother(){}
	virtual ~ThicknessSmoother(){}	
        private:
	typedef float PixelType;
  typedef itk::Image< PixelType, 3 > ImageType;
	typedef ImageType::Pointer ImagePointer;
	typedef itk::GaussianBlurImageFunction < ImageType > gaussFilterType;
	typedef itk::ImageRegionIteratorWithIndex< ImageType > IteratorType;
	typedef itk::NeighborhoodIterator< ImageType > NeighborhoodIteratorType;
	typedef itk::DiscreteGaussianImageFilter < ImageType, ImageType > gaussiFilterType;
	typedef itk::BinomialBlurImageFilter<ImageType,  ImageType>  FilterType;
	typedef itk::BinaryBallStructuringElement<PixelType, 3> myKernelType;
	typedef itk::GrayscaleDilateImageFilter<ImageType,  ImageType, myKernelType>  DilateFilterType;

	ImagePointer ThreshholdImage;
	ImagePointer InputImage;
	ImagePointer DanImage;
	ImagePointer SmoothImage;
	ImagePointer MaskImage;
	ImagePointer DilateImage;
        double VarianceT;
        bool VarT;
	
public:
	
	void ThickSmoother();
	void Threshhold_Image();
	void SetInput_dan(ImagePointer Image){DanImage = Image;}
        void SetVarianceT(double V){VarianceT=V; VarT=1;}
        void BoolVarianceT(){VarT=0;}
	ImagePointer GetOutput(){ return InputImage;}
	ImagePointer GetSmoothImage(){return SmoothImage;}
	void SetInput(ImagePointer Image){ InputImage = Image;}	
	ImagePointer CreateNewImageLike(ImagePointer OriginalImage);
};

#endif
