#include <itkImage.h>
#include <itkImageFileReader.h>
#include "itkImageRegionIteratorWithIndex.h"
#include <itkContinuousIndex.h>
#include <itkImageFileWriter.h>
#include <itkLinearInterpolateImageFunction.h>
#include <itkDiscreteGaussianImageFilter.h>
#include <itkPoint.h>

#include "itkImageToVTKImageFilter.h"

#include <itkDefaultDynamicMeshTraits.h>
#include <itkMetaMeshConverter.h>

#include <vtkPolyData.h>
#include <vtkPolyDataReader.h>
#include <vtkImageMarchingCubes.h>
#include <vtkDecimatePro.h>
#include <vtkMassProperties.h>
#include <vtkPolyDataWriter.h>

#include "vtkPolyDataToitkMesh.h"

#include <iostream>
#include <fstream>
#include <vector>
#include <cstdlib>



#include "ThicknessSmoother.h"
#include "DanielssonInterpolator.h"

#define PI 3.141592653589793238462643
const unsigned int Dimension = 3;

class Write_Mesh
{
 public:
	Write_Mesh(){};
	~Write_Mesh(){};

	void generateMesh();
	void writeAttr();
	void generateMeshAttr();
        void readMetaFile();
	void readVTKFile();
	void convertVTKToMeta();

	//LoadFileName
	const char * m_FileName;	
	const char * Get_FileName() { return m_FileName;}
	void Set_FileName(const char * name) { m_FileName = name; }
        
        //Load Attribute File Name
	const char * m_AttrFileName;	
	const char * Get_AttrFileName() { return m_AttrFileName;}
	void Set_AttrFileName(const char * name) { m_AttrFileName = name; }  
        
        //Load Variance of Image
        double m_VarianceI;
        bool m_VarI;
        void Set_VarianceI(const char * var) { m_VarianceI = std::atof(var); m_VarI = 1; }
        void Bool_VarianceI() { m_VarI = 0; }
        
        //Load Variance of Thickness
        double m_VarianceT;
        bool m_VarT;
        void Set_VarianceT(const char * var) { m_VarianceT = std::atof(var); m_VarT = 1; }
        void Bool_VarianceT() { m_VarT = 0; }

	bool m_IsSaveSmoothOn;
	void SaveSmoothOn(bool _IsSaveSmoothOn){m_IsSaveSmoothOn = _IsSaveSmoothOn;};
	bool IsSaveSmoothOn(){return m_IsSaveSmoothOn;};
        
        std::vector < float > thick ;

        float VarianceI;
        float VarianceT;
        bool VarI;
        bool VarT;
	
	int m_SignVector[3];
	void Set_SignVector(const char * _SignX, const char * _SignY, const char * _SignZ){m_SignVector[0] = std::atoi(_SignX); m_SignVector[1] = std::atoi(_SignY); m_SignVector[2] = std::atoi(_SignZ);};

	typedef float PixelType;
	typedef itk::Point< PixelType, Dimension> PointType;
	typedef itk::Image< PixelType, Dimension > ImageType;
	typedef itk::ImageRegionIteratorWithIndex< ImageType > IteratorType;
	typedef itk::ImageFileReader< ImageType  >  ReaderType;
	typedef itk::ImageFileWriter< ImageType  >  WriterType;
	typedef itk::LinearInterpolateImageFunction< ImageType, PixelType > InterpolatorType;
	
	typedef itk::DiscreteGaussianImageFilter < ImageType, ImageType > gaussFilterType;
	typedef itk::ImageToVTKImageFilter<ImageType> Itk2VtkType;
	typedef itk::DefaultDynamicMeshTraits < float, 3, 3 ,float, float> MeshTraitsType ; 
	typedef itk::Mesh < float, 3, MeshTraitsType > MeshType ;

	typedef itk::MeshSpatialObject < MeshType > MeshSOType ;
	typedef itk::MetaMeshConverter < 3, float, MeshTraitsType > MeshConverterType ;
	typedef MeshTraitsType::PointType MeshPointType;

	MeshType::Pointer m_inputMesh;
	vtkPolyDataReader *m_VTKreader;
	vtkPolyData *m_polydata;
};
