/*=========================================================================
  Program:   MeshInflation
  Module:    $RCSfile: MeshInflation.cxx,v $
  Language:  C++
  Date:      $Date: 2010/06/07 15:56:36 $
  Version:   $Revision: 1.3 $
  Author:    Clement Vachet (cvachet@email.unc.edu)

  Copyright (c) Clement Vachet. All rights reserved.
  See NeuroLibCopyright.txt or http://www.ia.unc.edu/dev/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#include <iostream>

#include "MeshInflationCLP.h"
#include "ComputeInflation.h"

int main(int argc, char *argv[])
{
  PARSE_ARGS;

  ComputeInflation Compute(InputMesh, OutputMesh, Smooth, MeanCurvature, MaxIterations, MaxIterationsBeforeFixing, MaxCurvature, IsIntermediateMesh, IntermediateMeshIteration);
  Compute.ReadMesh();
  Compute.InflateMesh();
  Compute.WriteMesh(OutputMesh);

  if (!CurvatureFile.empty())
    Compute.WriteCurvatureAttributeFile(CurvatureFile);  
  
  return 0;
}
