#ifndef COMPUTATION_H
#define COMPUTATION_H

#include <cstring>

//ITK
#include <itkImage.h>
#include <itkImageFileReader.h> 
#include <itkImageFileWriter.h>
#include <itkCovariantVector.h>
#include <itkImageRegionIterator.h>
#include <itkImageRegionConstIterator.h>
#include <itkNeighborhoodIterator.h>
#include <itkSubtractImageFilter.h>
#include <itkMinimumMaximumImageCalculator.h>

//----
#include <itkBinaryBallStructuringElement.h> 
#include <itkBinaryDilateImageFilter.h> 
//----

const int Dimension = 3;
typedef unsigned short ImagePixelType;
typedef short sImagePixelType;
typedef float SmoothImagePixelType;
typedef itk::Image<ImagePixelType,Dimension> ImageType;
typedef itk::Image<sImagePixelType,Dimension> sImageType;
typedef itk::ImageFileReader<ImageType> VolumeReaderType;
typedef itk::ImageFileWriter<ImageType> VolumeWriterType;
typedef itk::ImageRegionIterator<ImageType> IteratorType;
typedef itk::ImageRegionConstIterator<ImageType> ConstIteratorType;
typedef itk::NeighborhoodIterator<ImageType> NeighborhoodIteratorType;
typedef itk::SubtractImageFilter<ImageType,ImageType,sImageType> subFilterType;
typedef itk::MinimumMaximumImageCalculator<sImageType> minmaxImageCalculatorType;

//----
typedef itk::BinaryBallStructuringElement<ImagePixelType,Dimension> StructuringElementType;
typedef itk::BinaryDilateImageFilter<ImageType,ImageType,StructuringElementType> dilateFilterType;
//----

//Mesh Information
typedef itk::CovariantVector<double,3> CovariantVectorType;

class Computation
{
 public:
  Computation();
  ~Computation();
  
  void ReadImage(std::string _FileName);
  void ReadMesh(std::string _FileName);
  void ReadTextFile(std::string _FileName);
  void FixImage();
  void ConnectivityEnforcement();
  bool CheckOutput();
  void WriteCorrectionImage(std::string _FileName);
  void WriteOutputImage(std::string _FileName);

  //-----
  void SetNeighborhood(bool _Neighborhood){m_Neighborhood = _Neighborhood;};
  //-----
  
  
 private:  
  void SetNbVertices(int _NbVertices){m_NbVertices = _NbVertices;};
  void SetNbBadVertices(int _NbBadVertices){m_NbBadVertices = _NbBadVertices;};
  int GetNbVertices(){return m_NbVertices;};
  int GetNbBadVertices(){return m_NbBadVertices;};

  void FindBadPixels();
  void OutputImageAllocation();
  void ProcessedImageCreation();
  bool MajorityVoting();
  
  int NoDiagConnect(unsigned short *image, int *dim);
  void clear_edge(unsigned short *image, int *dims, int clear_label);
  void WriteImage(std::string _FileName, ImageType::Pointer _Image);
  
  //----
  bool GetNeighborhood(){return m_Neighborhood;};
  void Dilation();
  bool m_Neighborhood;
  //----

  ImageType::Pointer m_inputImage, m_processedImage, m_correctionImage, m_outputImage;
  
  // Mesh Information
  int m_NbVertices, m_NbBadVertices;  
  std::vector<CovariantVectorType> m_vVertices;
  std::vector<int> m_vIndexBadVertices;
};

#endif
