#include <iostream>
#include <cstring>

#include "argio.h"
#include "Computation.h"

// Methods
void DisplayHelp(std::string ProgName);

int main(int argc, const char* argv[])
{
  if ((argc < 5) || ipExistsArgument(argv, "--help"))
    {
      DisplayHelp(argv[0]);
      return EXIT_FAILURE;
    }
  else
    {
      Computation computation;

      // Reading input image
      computation.ReadImage(argv[1]);

      // Reading input mesh (.meta)      
      computation.ReadMesh(argv[2]);

      // Reading bad vertices (text file)
      computation.ReadTextFile(argv[3]);

      if (ipExistsArgument(argv, "--neighborhood"))
	computation.SetNeighborhood(true);
      else
	computation.SetNeighborhood(false);
    
      computation.FixImage();
      if (!ipExistsArgument(argv, "--noConnEnforcement"))
	computation.ConnectivityEnforcement();

      bool IsOutputNew = true;
      IsOutputNew = computation.CheckOutput();
      if (!IsOutputNew)
	std::cout<<"No modification ..."<<std::endl;
      else
	{
	  // Write correction image
	  if (ipExistsArgument(argv, "--saveCorrIm"))
	    computation.WriteCorrectionImage(ipGetStringArgument(argv, "--saveCorrIm", NULL));
	  
	  // Write Image
	  computation.WriteOutputImage(argv[4]);
	}      
    }
  return EXIT_SUCCESS;
}

void DisplayHelp(std::string ProgName)
{
  std::cerr<<"usage: "<<ProgName<<" <InputImage> <InputMesh> <BadVerticesFile> <OutputImage>"<<std::endl;
  std::cerr<<" --saveCorrIm CorrectionImage: Save correction image"<<std::endl;
  std::cerr<<" --noConnEnforcement: Disable connectivity enforcement"<<std::endl;
  std::cerr<<" --neighborhood: Consider neighborhood"<<std::endl;
  std::cerr<<" --help: Display help"<<std::endl;
}

