/*=========================================================================
  Program:   WMSegPostProcess
  Module:    $RCSfile: Computation.h,v $
  Language:  C++
  Date:      $Date: 2009/01/14 20:05:39 $
  Version:   $Revision: 1.1 $
  Author:    Clement Vachet (cvachet@email.unc.edu)

  Copyright (c) Clement Vachet. All rights reserved.
  See NeuroLibCopyright.txt or http://www.ia.unc.edu/dev/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef COMPUTATION_H
#define COMPUTATION_H

#include <iostream>
#include <string>

// ITK
#include <itkImage.h>
#include <itkImageFileReader.h> 
#include <itkImageFileWriter.h>
#include <itkImageRegionIterator.h>
#include <itkConnectedComponentImageFilter.h>
#include <itkRelabelComponentImageFilter.h>
#include <itkBinaryThresholdImageFilter.h> 
#include <itkNeighborhoodIterator.h>
#include <itkImageRegionIterator.h>
#include <itkImageRegionConstIterator.h>
#include <itkSubtractImageFilter.h>

using namespace itk;
using namespace std;


const int Dimension = 3;
typedef unsigned short ImagePixelType;

typedef Image<ImagePixelType,Dimension>  ImageType;

typedef ImageFileReader<ImageType> VolumeReaderType;
typedef ImageFileWriter<ImageType> VolumeWriterType;
typedef ConnectedComponentImageFilter<ImageType,ImageType> ConnectiveFilterType;
typedef RelabelComponentImageFilter<ImageType,ImageType> RelabelFilterType;
typedef BinaryThresholdImageFilter<ImageType,ImageType> threshFilterType;
typedef ImageRegionIterator<ImageType> IteratorType;
typedef NeighborhoodIterator<ImageType> NeighborhoodIteratorType;
typedef ImageRegionIterator<ImageType> IteratorType;
typedef ImageRegionConstIterator<ImageType> ConstIteratorType;
typedef SubtractImageFilter<ImageType,ImageType,ImageType> subFilterType;

class Computation
{
 public:
  Computation(string _InputImageName, string _OutputImageName);
  ~Computation();
  
  void ReadImage();
  void LargestComponent();
  void InsideFilling();
  void Smoothing();
  void ConnectivityEnforcement();
  void WriteImage();
  
 private:  
  // IO
  void SetInputImage(string _InputImageName){m_InputImageName = _InputImageName;};
  void SetOutputImage(string _OutputImageName){m_OutputImageName = _OutputImageName;};

  string GetInputImage(){return m_InputImageName;};
  string GetOutputImage(){return m_OutputImageName;};

  void ComputeLargestComponent(ImageType::Pointer _inputImage, ImageType::Pointer &_outputImage);
  int NoDiagConnect(unsigned short *image, int *dim);
  void clear_edge(unsigned short *image, int *dims, int clear_label);

  
  string m_InputImageName, m_OutputImageName;
  ImageType::Pointer m_inputImage;
};

#endif
