/*=========================================================================
  Program:   WMSegPostProcess
  Module:    $RCSfile: WMSegPostProcess.cxx,v $
  Language:  C++
  Date:      $Date: 2009/01/27 19:58:44 $
  Version:   $Revision: 1.2 $
  Author:    Clement Vachet (cvachet@email.unc.edu)

  Copyright (c) Clement Vachet. All rights reserved.
  See NeuroLibCopyright.txt or http://www.ia.unc.edu/dev/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#include <iostream>

#include "WMSegPostProcessCLP.h"
#include "Computation.h"

int main(int argc, char *argv[])
{
  PARSE_ARGS;

  Computation Compute(InputImage, OutputImage);

  Compute.ReadImage();
  if (!NoLC)
    Compute.LargestComponent();
  if (!NoSmoothing)
    Compute.Smoothing();
  if (!NoConnEnforcement)
    Compute.ConnectivityEnforcement();
  if (!NoInsideFilling)
    Compute.InsideFilling();
  Compute.WriteImage();

  return EXIT_SUCCESS;
}
