/**
 * \file timer.cc
 * \brief implementation of timer.h
 * \author Yinpeng Li (mousquetaires@unc.edu)
*/

#include "timer.h"

Timer::Timer()
{
  start_ = boost::posix_time::second_clock::universal_time() ;
}

void Timer::restart()
{
  start_ = boost::posix_time::second_clock::universal_time() ;
}

std::string Timer::elapsed()
{
  return boost::posix_time::to_simple_string(boost::posix_time::second_clock::universal_time() - start_) ;
}
