/**
 * \file timer.h
 * \brief Contains class definition for displaying the progress bar in the console.
 * \author Yinpeng Li (mousquetaires@unc.edu)
*/

#ifndef TIMER_H_
#define TIMER_H_

#include <boost/date_time.hpp>

/** 
 * \class Timer
 * \brief For displaying the progress bar in console execution 
*/
class Timer
{
protected:
  boost::posix_time::ptime start_ ;
public:
  Timer() ;
  virtual void restart() ;
  virtual std::string elapsed() ;
  virtual ~Timer() {}
} ;

#endif
