function [tstat, uncPval] = ssfmri_Ttest(Beta_hat,Beta_conf,Cov_bc,COV_d,Fw,FX_band,num_voxROI,bands,con)
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INFERENCE PART
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Inference for H0 :beta_seed_c = 0 
% Need to have Cov(beta_c)
% Define SIG_B = sum(Cov_b1, Cov_b2) for each cluster
% Cov_bc is a num_ROI*num_event cell
% COV_d is a 2*num_band cell (num_band=2 in simulation), first row for real
% part, second row for imaginary part

tot_freq = size(FX_band,1);
num_ROI = length(num_voxROI);
num_event = size(FX_band,2);
num_band = length(bands);

%% comput pinv(X*'X*), A
% FX_band is design matrix with num_freq x num_covN
XG = pinv(real(FX_band)'*real(FX_band)+imag(FX_band)'*imag(FX_band)); 
XA = cell(num_event,1);
for p = 1:num_event
    Xp_R = zeros(size(FX_band));
    Xp_I = zeros(size(FX_band));
    for j = 1:num_event
        Xp_R(:,j) = real(FX_band(:,p)).*real(FX_band(:,j));
        Xp_I(:,j) = imag(FX_band(:,p)).*imag(FX_band(:,j));
    end
    XA{p} = XG*(Xp_R'*Xp_R+Xp_I'*Xp_I)*XG;
end

%% Bp
Bp = cell(num_event,1);
for p = 1:num_event
    Bp{p} = zeros(num_ROI);
    for clust = 1:num_ROI
        Bp{p}(clust,clust) = sum(Cov_bc{clust,p}(:))/(num_voxROI(clust)^2);
    end
end

ABp = kron(XA{1},Bp{1});
if num_event > 1
    for p = 2:num_event
        ABp = ABp + kron(XA{p},Bp{p});
    end
end

%% Dj
XD = cell(num_band,1);
k_end = 0;
for i = 1:num_band
    k_start = k_end+1;
    k_end = k_end+length(bands{i});
    XD{i} = XG*(FX_band(k_start:k_end,:)'*FX_band(k_start:k_end,:))*XG;
end
Dsig = kron(XD{1},COV_d{1,1}+COV_d{2,1});
FD = Fw(1)*XD{1};
if num_band > 1
    for i = 1:num_band
        Dsig = Dsig + kron(XD{i},COV_d{1,i}+COV_d{2,i});
        FD = FD + Fw(i)*XD{i};
    end
end

%%

COV_Beta = ABp + Dsig + kron(FD,diag(1./num_voxROI));
%%
% Now do inference at each ROI
tstat = cell(length(con),1);
pval_spat_spec = cell(length(con),1);

for t = 1:length(con)
    beta_diff_spat = zeros(1,num_ROI);
    SE_beta_diff_spat = zeros(1, num_ROI);
    tstat{t} = zeros(num_ROI,1);
    for clust = 1:num_ROI
        k = (num_event*clust) - (num_event-1);
        k_end = num_event*clust;
        temp_b = Beta_hat(clust,:);
        temp_b = temp_b(:);
        temp_cov = COV_Beta(k:k_end,k:k_end); 

        beta_diff_spat(1,clust) = con{t}*temp_b;
        SE_beta_diff_spat(1,clust) = sqrt(con{t}*temp_cov*con{t}');
        tstat{t}(clust,1) = con{t}*temp_b/sqrt(con{t}*temp_cov*con{t}');
    end

    pval_spat_spec{t}=zeros(num_ROI, 1);
    for clust=1:num_ROI    
       temp_stat=abs(tstat{t}(clust));
       pval_spat_spec{t}(clust)=2*(1-normcdf(temp_stat,0,1));
    end
end

uncPval = pval_spat_spec;

end