function [tstat, uncPval] = ssfmri_Ttest_rs(Beta_hat,Beta_conf,Cov_bc,COV_d,Fw,FX_band,num_voxROI,F_freq,con,h0)
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INFERENCE PART
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Inference for H0 :beta_seed_c = 0 
% Need to have Cov(beta_c)
% Define SIG_B = sum(Cov_b1, Cov_b2) for each cluster
% Cov_bc is a num_ROI*num_event cell
% COV_d is a num_band*2 cell (num_band=3 in simulation), first column for real
% part, second row for imaginary part

num_ROI = length(num_voxROI);
num_covN = size(FX_band,2);

%% comput pinv(X*'X*), A
% FX_band is design matrix with num_freq x num_covN
freq_tot = [];
for k = 1:length(F_freq)
    freq_tot = [freq_tot;F_freq{k}];
end

XG = pinv((real(FX_band(freq_tot,:)))'*real(FX_band(freq_tot,:))+(imag(FX_band(freq_tot,:)))'*imag(FX_band(freq_tot,:))); 
Fx_A_R = zeros(length(freq_tot),num_covN);
Fx_A_I = zeros(length(freq_tot),num_covN);
for j = 1:num_covN
    Fx_A_R(:,j) = real(FX_band(freq_tot,1)).*real(FX_band(freq_tot,j));
    Fx_A_I(:,j) = imag(FX_band(freq_tot,1)).*imag(FX_band(freq_tot,j));
end
XA = XG*(Fx_A_R'*Fx_A_R+Fx_A_I'*Fx_A_I)*XG;

As = XA(1,1);

HD = zeros(num_ROI);
for k = 1:length(F_freq)
    XHR = XG*(real(FX_band(F_freq{k},:)))'*real(FX_band(F_freq{k},:))*XG;
    XHI = XG*(imag(FX_band(F_freq{k},:)))'*imag(FX_band(F_freq{k},:))*XG;
    HsR = XHR(1,1);
    HsI = XHI(1,1);
    HD = HD + HsR*COV_d{k,1} + HsI*COV_d{k,2};
end

XQX = zeros(num_covN);
for k = 1:length(F_freq)
    XQX = XQX + Fw{k}/2*((real(FX_band(F_freq{k},:)))'*real(FX_band(F_freq{k},:)) + (imag(FX_band(F_freq{k},:)))'*imag(FX_band(F_freq{k},:)));
end
XQ = XG*XQX*XG;
Qs = XQ(1,1);
    
%%
COV_invb = zeros(num_ROI);
COV_invbinvb = zeros(num_ROI);
for clust = 1:num_ROI
    Cov_invbc = pinv(Cov_bc{clust});
    COV_invb(clust,clust) = sum(Cov_invbc(:));
    Cov_invbcinv = Cov_invbc*Cov_invbc;
    COV_invbinvb(clust,clust) = sum(Cov_invbcinv(:));
end
inv_KinvbK = pinv(COV_invb);

COV_Beta = As*inv_KinvbK + HD + Qs*inv_KinvbK*COV_invbinvb*inv_KinvbK;

% %%% beta from mean(gamma)
% inv_KK = zeros(num_ROI);
% for clust = 1:num_ROI
%     inv_KK(clust,clust) = 1/num_voxROI(clust);
% end
% COV_Beta = As*inv_KK*COV_invb*inv_KK + HD + Qs*inv_KK;

%%
% Now do inference at each ROI
tstat = cell(length(con),1);
pval_spat_spec = cell(length(con),1);

for t = 1:length(tstat)
    tstat{t} = zeros(num_ROI,1);
    if abs(con{t}(1)) == 1
        for clust = 1:num_ROI
            tstat{t}(clust,1) = con{t}(1)*Beta_hat(clust)/sqrt(COV_Beta(clust,clust));
        end
    else
        display('confound inference');
        return;
    end

    pval_spat_spec{t}=zeros(num_ROI, 1);
    dof = size(FX_band,1) - size(FX_band,2);
    
    if strcmp(h0{t}, 'ONE')
        % one sided t-test
        for clust=1:num_ROI 
           pval_spat_spec{t}(clust) = 1 - tcdf(tstat{t}(clust),dof); % one sided t-test
        end 
    else
        for clust=1:num_ROI 
           pval_spat_spec{t}(clust) = 2*(1 - tcdf(abs(tstat{t}(clust)),dof)); % two sided t-test
        end
    end
end
uncPval = pval_spat_spec;

end