function [SSF] = ssfmri_con_man(SSF)
% This function does the t-tests and calculates corrected p-values
% Right now only FDR correction available.

if nargin < 1      
    
    error('GUI out of service for now\n Use command line options for now.');
%     
%     %-------------- set parameters via GUI --------------------------% 
%     %clear all;
%     H = spm('FnUIsetup','Spatio-Spectral fMRI Contrast Manager',0);
%     % Loading the SSF structure
%     SSF_fname  = spm_select(1, 'mat', 'Select the SSF.mat file ...', [], pwd, '.*');
%     cd(fileparts(SSF_fname));
%     load(SSF_fname);
% 
%     %---------------------------    
%     % list contrast components
%     nPar = length(SSF.titles) ;
%     
%     %disp(nPar);
%     %axes('Position',[0.55 .35 0.42 (nPar+1)*.05],...
%     axes('Position',[0.55 .4 0.42 .5],...
%         'Tag','ConAx','Visible','on')
%     set(gca,'Tag','ConAx',...
%         'Box','on','TickDir','out',...
%         'XTick',[],...
%         'XLim',	[0,nPar],...
%         'YTick',[],...
%         'YLim',	[0,nPar] ...
%         )
%     for i = 1:nPar
%         
%         str = ['  ' upper(SSF.titles{i})];        
%         text(i-.75, .5, str, ...
%             'FontSize',spm('FontSize',12),...
%             'FontAngle','Normal',...
%             'HorizontalAlignment','Left',...
%             'VerticalAlignment','Middle', ...
%             'Rotation', 90)   
%     end
%     %---------------------------
% 
%     % Generating or requesting the contrast for regression
%   
%     SSF.Type_STAT = 'T';
%     H0{1} = spm_input('Select Test','1','m', ...
%     'One Sided|Two Sided', ...
%        ['ONE' ; ...
%         'TWO']);
%     
%     c{1} = spm_input(sprintf('Enter t-test contrast '),'11','e');   
% %     c=c(:);
%     
%     %----- multiple comparison methods -----%
%     correct = spm_input('Select multiple comparison method','1','m', ...
%         'FWE Correction|FDR Correction|Uncorrect', ...
%            ['FWE      ' ; ...
%             'FDR      ' ; ...
%             'UNCORRECT']);
%     alpha = spm_input([SSF.correct ' threshold'],'+1','e');
% 
%     if spm_input('Clear contrast history? ','+1','y/n',[1 0],2)
%         SSF.test = [];
%     end
%     if ~isfield(SSF,'test')
%         SSF.test    = cell(1);
%         SSF.test{1}.con = c{1};
%         SSF.test{1}.H0 = H0{1};
%         SSF.test{1}.correct = correct;
%         SSF.test{1}.alpha = alpha;
%     else 
%         SSF.test{length(SSF.contrast)+1}.con = c{1};
%         SSF.test{length(SSF.contrast)+1}.H0 = H0{1};
%         SSF.test{length(SSF.contrast)+1}.correct = correct;
%         SSF.test{length(SSF.contrast)+1}.alpha = alpha;
%     end   
%     
%     close(H);       
else
    % Command line branch of execution
    c = cell(length(SSF.test),1);
    H0 = cell(length(SSF.test),1);
    for i = 1:length(SSF.test)
        c{i} = SSF.test{i}.con;
        H0{i} = SSF.test{i}.H0;
    end

end

Beta_hat = SSF.estResults.beta_hat;
Cov_bc = cell(length(SSF.estResults.cov_b),1);
for clust = 1:length(SSF.estResults.cov_b)
    Cov_bc{clust} = SSF.estResults.cov_b{clust}.V;
end
Cov_d = SSF.estResults.cov_d;
Fw = SSF.estResults.fw;
num_voxROI = SSF.estResults.ROI_numVox;
FX_band = SSF.X_band;
F_freq = SSF.estResults.freq;

switch SSF.type    
    case{'EVENT'}
        Beta_conf = [];
        [tstat, pval] = ssfmri_Ttest(Beta_hat,Beta_conf,Cov_bc,Cov_d,Fw,FX_band,num_voxROI,SSF.band,c);
        
    case{'REST'}
        Beta_conf = SSF.estResults.beta_conf;
        [tstat, pval] = ssfmri_Ttest_rs(Beta_hat,Beta_conf,Cov_bc,Cov_d,Fw,FX_band,num_voxROI,F_freq,c,H0);
end

% check for and add 'test' field if necessary
newT_ind = 0;
if ~isfield(SSF,'test')
    SSF.test = cell(length(pval));    
else
    for i = 1:length(SSF.test)
        if isfield(SSF.test{i},'pval')
            newT_ind = newT_ind + 1;
        end
    end
end

for i = 1:length(pval)
    SSF.test{newT_ind+i}.pval = pval{i};
    SSF.test{newT_ind+i}.tstat = tstat{i};
end

% FDR correction - produces SSF.test{newT_ind+i}.correctPval which is a logical array
num_ROI = length(num_voxROI);
for i = 1:length(pval) %
    if strcmp(SSF.test{newT_ind+i}.correct,'FDR')
        increment=SSF.test{newT_ind+i}.alpha/num_ROI;
        FDR_vec = increment:increment:SSF.test{newT_ind+i}.alpha;
        pval_spat_ordered = sortrows(pval{i});
        FDR_pthred = pval_spat_ordered(find(pval_spat_ordered <= FDR_vec',1,'last'));
            if isempty(FDR_pthred); FDR_pthred=0; end;
        FDR_result_spat = pval{i} <= FDR_pthred; 
        SSF.test{newT_ind+i}.correctPval = FDR_result_spat;
    end
end

% % ------------- Update SSF.mat file -------------------------- %
if nargin < 1
   save(SSF_fname, 'SSF');
   spm_figure('Clear','Interactive'); 
else 
   SSF_fname = fullfile(SSF.result_dir,'SSF.mat');
   save(SSF_fname, 'SSF');
end

