function [beta_hat_clust, Cov_bc, COV_d_out, Fw, num_voxROI] = ssfmri_est(FX_band,Y_band,conf_band,bands_all,nbin,bands,coord_ROIs)

disp('in ssfmri_est'); 
keyboard; 

% Compute OLS for each ROI
num_ROI = length(Y_band);
num_event = size(FX_band,2);
% Firstsump=zeros(num_event, num_event);
num_band = length(bands);
 
fx = FX_band; 
Firstsump = real(fx)'*real(fx)+imag(fx)'*imag(fx);

num_voxROI = zeros(num_ROI,1);
for clust = 1:num_ROI
    num_voxROI(clust) = size(coord_ROIs{clust},1);
end

gamma_OLS=cell(num_ROI,1);
for clust=1:num_ROI
    fx = FX_band;
    Secondsump = real(fx)'*real(Y_band{clust})' + imag(fx)'*imag(Y_band{clust})';
    gamma_OLS{clust}=(pinv(Firstsump)*Secondsump);
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Estimate beta_c, cluster-specific fixed effect %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% By definition gamma_OLS = beta_c + b_vc
% Iteratively we can estimate beta_c and sigma_bc

% beta_OLS
gamma_OLS123 = cell(num_ROI,1);

beta_c0 = zeros(num_ROI,num_event);

for clust = 1:num_ROI
    gamma_OLS123{clust} = gamma_OLS{clust}';
%     
%     for i = 1:num_event
%         beta_c0(clust,i) = mean(gamma_OLS{clust}(i,:));
%     end
end

% Estimate Beta_c and Sigma_bc for each stimulus
% ResidR = cell(num_ROI,1);
% for clust = 1:num_ROI    
%     temp_r=gamma_OLS123{clust}-repmat(beta_c0(clust,:),num_voxROI(clust),1);
%     ResidR{clust} = temp_r;
% end
% 
% max_iter = 100; % maximum number of iterations


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% estimate covariance matrix of d_c
Residgamma_R = cell(num_ROI,1);
Residgamma_I = cell(num_ROI,1);

% compute Residuals at each frequency and each ROI, Zcv(w)
for clust = 1:num_ROI
    tempY=Y_band{clust};
    tempgam = gamma_OLS123{clust};
    Resid_Rtemp = [];
    Resid_Itemp = [];
    for j=1:length(bands_all)
        tempXR = repmat(real(FX_band(j,:)),num_voxROI(clust),1);
        tempXI = repmat(imag(FX_band(j,:)),num_voxROI(clust),1);

        tempXGamR = sum(tempXR.*tempgam, 2);
        tempXGamI = sum(tempXI.*tempgam, 2);

        % Compute residuals for Real and Imaginary
        tempResidR = real(tempY(:,j)) - tempXGamR;
        tempResidI = imag(tempY(:,j)) - tempXGamI;

        Resid_Rtemp = [Resid_Rtemp, tempResidR];
        Resid_Itemp = [Resid_Itemp, tempResidI];
    end
    Residgamma_R{clust} = Resid_Rtemp;
    Residgamma_I{clust} = Resid_Itemp;    
end

ResidgammaR_band = cell(num_ROI, num_band);
ResidgammaI_band = cell(num_ROI, num_band);

% rearrange the residual by band
for clust = 1:num_ROI
    resid_bandR = cell(num_band,1);
    resid_bandI = cell(num_band,1);
    tempR1 = Residgamma_R{clust};
    tempI1 = Residgamma_I{clust};
    pre_end = 0;

    for i = 1:num_band
        resid_bandR{i} = tempR1(:,1+pre_end:pre_end+length(bands{i}));
        resid_bandI{i} = tempI1(:,1+pre_end:pre_end+length(bands{i}));
        pre_end = pre_end+length(bands{i});
        
        ResidgammaR_band{clust, i} = resid_bandR{i};
        ResidgammaI_band{clust, i} = resid_bandI{i};
    end   
end

%% estimate off-diagonal elements of covariance matrix of d_c

% Now compute pairwise correlation between any voxel in ROI1 and voxel
% in ROI2
meancorR = cell(num_band,1);
meancorI = cell(num_band,1);
for nb = 1:num_band
    meancorR{nb}=zeros(num_ROI,num_ROI);
    meancorI{nb}=zeros(num_ROI,num_ROI);
end
for clust=1:num_ROI-1
    for clust1=clust+1:num_ROI
        for i = 1:num_band
            % Real part
            meancorR{i}(clust,clust1)=corr(mean(ResidgammaR_band{clust,i})', mean(ResidgammaR_band{clust1,i})');
%             meancorR{i}(clust,clust1) = meanCorr(ResidR1_band{clust,i}, ResidR1_band{clust1,i});
            % Imaginary part
            meancorI{i}(clust,clust1)=corr(mean(ResidgammaI_band{clust,i})', mean(ResidgammaI_band{clust1,i})');
%             meancorI{i}(clust,clust1) = meanCorr(ResidI1_band{clust,i}, ResidI1_band{clust1,i});
        end
    end
end

%% estimate diagonal elements of covariance matrix of d_c

sig2d_R = cell(num_band,1);
sig2d_I = cell(num_band,1);
for nb = 1:num_band
    sig2d_R{nb}=zeros(num_ROI,1);
    sig2d_I{nb}=zeros(num_ROI,1);
end

for clust=1:num_ROI
    for i = 1:num_band
%         % Real part
%         sig2d_R{i}(clust)=median(median(cov(ResidgammaR_band{clust,i}')));       
%         % Imaginary part
%         sig2d_I{i}(clust)=median(median(cov(ResidgammaI_band{clust,i}'))); 
        
        %%% 
        sig2d_R{i}(clust) = meanCov(ResidgammaR_band{clust,i});
        sig2d_I{i}(clust) = meanCov(ResidgammaI_band{clust,i});
        
        %%% only consider cov between different voxels
%         covR = cov(ResidgammaR_band{clust,1}');
%         covI = cov(ResidgammaI_band{clust,1}');
%         tmpcovR = covR(eye(size(covR)) == 0);
%         tmpcovI = covI(eye(size(covI)) == 0);
%         sig2d_R{i}(clust) = mean(abs(tmpcovR));
%         sig2d_I{i}(clust) = mean(abs(tmpcovI));

    end
end


%% Construnct Sig_d matrix at each band
disp('Construncting Sid_d matrix');
SIG_d_R = cell(1,num_band);
SIG_d_I = cell(1,num_band);
for i = 1:num_band
    % corr(x,y) = cov(x,y)/(sig(x)*sig(y))
    sig_dRb{i} = sqrt(sig2d_R{i})*sqrt(sig2d_R{i}');
    cor_dRb{i} = eye(num_ROI)+meancorR{i}+meancorR{i}';
    SIG_d_R{i} =  sig_dRb{i}.*cor_dRb{i};
    
    sig_dIb{i} = sqrt(sig2d_I{i})*sqrt(sig2d_I{i}');
    cor_dIb{i} = eye(num_ROI)+meancorI{i}+meancorI{i}';
    SIG_d_I{i} =  sig_dIb{i}.*cor_dIb{i};
end

% put those into an array 
COV_d_out = [SIG_d_R; SIG_d_I];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% spatial distance matrix
dist_matrix1 = cell(num_ROI,1);
dx1 = cell(num_ROI,1);

for clust = 1:num_ROI
    dx1{clust} = ones(num_voxROI(clust),1);
    distV = pdist(coord_ROIs{clust},'euclidean');    
    dist_matrix1{clust} = squareform(distV);
end

beta_hat_clust=zeros(num_ROI,num_event);
Cov_bc=cell(num_ROI,num_event);
V_b = cell(num_event,1);
V_b_inv = cell(num_event,1);
residRt = cell(num_event,1);
sigt = cell(num_event,1);
AA = cell(num_event,1);
inda = cell(num_event,1);
tempN = cell(num_event,1);
V_hat = cell(num_event,1);
V_hat_inv = cell(num_event,1);
firstsum = cell(num_event,1);
secondsum = cell(num_event,1);
beta_c = cell(num_event,1);
residRtNew = cell(num_event,1);

for clust=1:num_ROI
%     nbin = round(num_voxROI(clust)/bin_size);
%     beta_OLSt = beta_c0(clust,:);
    
    for i = 1:num_event
        V_b{i} = eye(num_voxROI(clust));
        V_b_inv{i} = eye(num_voxROI(clust));
    end 
    
    for i = 1:num_event
        residRt{i} = gamma_OLS123{clust}(:,i);
        sigt{i} = var(residRt{i});       
        AA{i} = variogram(coord_ROIs{clust},residRt{i},'nrbins',nbin, 'maxdist',max(max(dist_matrix1{clust}))/3);
        % For a target voxel, all voxels with distance within one bin have same effect on the target
        % voxel

        inda{i} = ~isnan(AA{i}.val);
        AA{i}.val = AA{i}.val(inda{i});
        AA{i}.distance = AA{i}.distance(inda{i});
        tempN{i} = (sigt{i} - AA{i}.val(1))*(dist_matrix1{clust} < AA{i}.distance(2));
    end

    beta_clust = [];
    for i = 1:num_event
        for j=inda{i}+1:length(AA{i}.val)-1
            temp1 = (sigt{i} - AA{i}.val(j+1))*(dist_matrix1{clust}>AA{i}.distance(j) & dist_matrix1{clust}<=AA{i}.distance(j+1));
            tempN{i} = tempN{i} + temp1;
        end
        tempN{i} = tempN{i}.*(tempN{i} >0);
        V_hat{i} = triu(tempN{i},1) +  diag(sigt{i}*ones(num_voxROI(clust),1))+ triu(tempN{i},1)';
        [U{i},S{i},V{i}] = svd(V_hat{i});
        V_hat_inv{i} = V{i}*diag((diag(S{i})).^-1)*U{i}';

        % First part of GLS 
        firstsum{i} = 1/sum(sum(V_hat_inv{i}));

        secondsum{i} = sum(V_hat_inv{i},1)*gamma_OLS123{clust}(:,i);

        beta_c{i} = firstsum{i}*secondsum{i};
        beta_clust = [beta_clust, beta_c{i}];
        residRtNew{i} = gamma_OLS123{clust}(:,i) - (beta_c{i}*dx1{clust});
    end

    for i = 1:num_event
        V_b{i}=V_hat{i};
        V_b_inv{i} = V_hat_inv{i};
    end
    
    beta_hat_clust(clust,:)=beta_clust;
    for k = 1:num_event
        Cov_bc{clust,k} = V_hat{k};
    end
end

%% Finally, estimate sig2_residual
% idea: compute VAR(Y-x\gamma) = VAR(d +\epsilon)
%                               = sig2d_c + sig2_resid
% Here sig2d_c was estimated, so the VAR - sig2d_c will
% be sig2_resid.

% should be done for Real and Imaginary, as well as for
% band 1 and band 2

% tot_freq = length(bands_all);
Sig2_Resid_R = cell(num_band,1);
Sig2_Resid_I = cell(num_band,1);
for nb = 1:num_band
    Sig2_Resid_R{nb} = zeros(num_ROI,1);
    Sig2_Resid_I{nb} = zeros(num_ROI,1);
end

for clust=1:num_ROI
    tempRvarn = cell(num_band,1);
    tempIvarn = cell(num_band,1);
    % Real part
    for i = 1:num_band
%%%      % for k runs
%         k_st = (length(bands{i})*k) - (length(bands{i})-1);
%         k_end=length(bands{i});
%         tempRvar1 = ResidgammaR_band{clust,i}';
%         tempRvar1n = tempRvar1(1:k_end,:); tempRvar1n = tempRvar1n(:);
        tempRvarn{i} = ResidgammaR_band{clust,i}';
        tempRvarn{i} = tempRvarn{i}(:);
        Sig2_Resid_R{i}(clust) = (var(tempRvarn{i})-sig2d_R{i}(clust));
%         Sig2_Resid_R{i}(clust) = Sig2_Resid_R{i}(clust).*Sig2_Resid_R{i}(clust)>0;
    
    % Imaginary part
        tempIvarn{i} = ResidgammaI_band{clust,i}';
        tempIvarn{i} = tempIvarn{i}(:);
        Sig2_Resid_I{i}(clust) = (var(tempIvarn{i})-sig2d_I{i}(clust));
    end

end

temp_fw = zeros(2,num_band); % first row for Real part, second row for Imaginary part
fw_new = zeros(num_band,1);
for nb = 1:num_band
    temp_fw(1,nb) = mean(Sig2_Resid_R{nb}(Sig2_Resid_R{nb}>0));
    temp_fw(2,nb) = mean(Sig2_Resid_I{nb}(Sig2_Resid_R{nb}>0));
    fw_new(nb) = mean(temp_fw(:,nb));
end
Fw = 2 * fw_new;

return