function [SSF] = ssfmri_results(SSF)

if nargin < 1      
    %-------------- set parameters via GUI --------------------------% 
    %clear all;
    H = spm('FnUIsetup','Spatio-Spectral fMRI Contrast Manager',0);
    % Loading the SSF structure
    SSF_fname  = spm_select(1, 'mat', 'Select the SSF.mat file ...', [], pwd, '.*');
    cd(fileparts(SSF_fname));
    load(SSF_fname);
    if isfield(SSF.ROI,'Lable')
        seedLable = spm_input('seed Lable value','+1','e');
        roi_str = spm_vol(SSF.ROI.Lable);
        roi_img = spm_read_vols(roi_str);
        Conn_str = roi_str;
        Conn_str.fname = fullfile(SSF.result_dir,'connectivity.nii');
        Conn_img = zeros(size(roi_img));
        Conn_img(roi_img == seedLable) = 1;
        
        connROI = SSF.ROI.LableVal(SSF.test.correct>0);
        for i = 1:length(connROI)
            Conn_img(roi_img == connROI(i)) = .5; 
        end
    else
        seedMask = spm_select(1, 'IMAGE', 'select seed mask', [], swd, '.*');
        seed_str = spm_vol(seedMask);
        seed_img = spm_read_vols(seed_str);
        Conn_str = seed_str;
        Conn_str.fname = fullfile(SSF.result_dir,'connectivity.nii');
        Conn_img = zeros(size(seed_img));
        Conn_img(seed_img > 0) = 1;
        
        connROI = find(SSF.test.correct > 0);
        roi_str = spm_vol(SSF.Mask);
        for i = 1:length(connROI)
            roi_maskimg = spm_read_vols(roi_str{connROI(i)});
            Conn_img(roi_maskimg > 0) = .5;
        end
    end
    
    spm_write_vol(Conn_str,Conn_img);
    
    close(H);       
else
    % Command line branch of execution
%     H = spm('FnUIsetup','Spatio-Spectral fMRI Contrast Manager',0); 

end

end