function [SSF, error, H] = ssfmri_setup
%----------------------------------------------%
%                      GUI                     %
%----------------------------------------------%

H = spm('FnUIsetup','Spatio-Spectral fMRI Analysis',0);
error = 0;

%----- Result directory ---------%
SSF.result_dir  = spm_str_manip(spm_select(1, 'dir', 'Results directory', [], pwd), '.*');

wdir = SSF.result_dir ;
disp(['Results directory:  ' wdir]);
cd(wdir);

%----- analysis type -----%
SSF.type = spm_input('Select type of analysis','1','m', ...
    'Event-related fMRI|Resting-state fMRI', ...
       ['EVENT' ; ...
        'REST ']);
swd = pwd;

% -------- generating the file ------------%
switch SSF.type
    case {'EVENT'}       
        SSF.type = 'EVENT';
        
        imgfmri = spm_select(Inf, 'IMAGE', 'select fMRI time series', [], swd, '.*');
        SSF.imgname = cellstr(imgfmri);
        SSF.RT = spm_input('Repetition Time (s)','+1');

        if ~spm_input('Any conditions file? ','+1','y/n',[1 0],0)
            nEvent = spm_input('How many stimulus?','0');
            for k = 1:nEvent
                SSF.titles{k} = spm_input(sprintf('Name of event #%d ',k),'+1','s');
                SSF.event{k}.onset = spm_input(['Event ' num2str(k) ' Onsets'],'0');
                SSF.event{k}.duration = spm_input(['Event ' num2str(k) ' Durations'],'+1');
            end
        else
            SSF.eventfile = spm_select(1, 'any', 'select conditions file', [], swd, '.*');
            % depends on the definition of the event condition file, not
            % works now, need later development
            eventInfo = load(SSF.eventfile);
            for k = 1:2:size(eventInfo,2)
                SSF.event{k}.onset = eventInfo(:,k);
                SSF.event{k}.duration = eventInfo(:,k+1);
            end
        end
        
        niCov = spm_input('Any non-event covariates? ','+1','y/n',[1,0],2);
        
        % ----- No regressors error ---------------------%
        if (nEvent == 0) && (niCov == 0)
            display('Regression requires at least one covariate')
            error = 1;
            return
        end
        
        % --- Selecting the file with non-event covariates information--%  
        % assume no non-event covariates in the first version
        if niCov > 0
            [SSF.conf, swd] = spm_select(1, 'any', 'select non-event covariates file', [], swd, '.*');
            col_cof = load(SSF.conf);
            nIC = size(col_cof,2);
            for cv = 1:nIC
                SSF.titles{nEvent+cv} = spm_input(sprintf('Name of non-event covariates #%d ',cv),'+1','s');
            end
        else
            SSF.conf = [];
        end
                
        type_ROIm = spm_input('Apply ROI mask/label','+1','b',{'Mask','Label'},[1,0],2);
        if type_ROIm
            ROImask = spm_select(Inf, 'IMAGE', 'select ROI mask', [], swd, '.*');
            SSF.ROI.Mask = cellstr(ROImask);
        else
            SSF.ROI.Label = spm_select(1, 'IMAGE', 'select ROI label', [], swd, '.*');
            SSF.ROI.LabelVal = spm_input('Intested ROI label value','+1');
        end
        
        nband = spm_input('How many bands? ','+1');
        for k = 1:nband
            SSF.band{k} = spm_input(sprintf('band #%d points',k),'+1');
        end
        
        SSF.nbin = spm_input('variogram bin #','+1');
        
    case {'REST'}
        SSF.type = 'REST';
        imgfmri = spm_select(Inf, 'IMAGE', 'select fMRI time series', [], swd, '.*');
        SSF.imgname = cellstr(imgfmri);
        SSF.RT = spm_input('Repetition Time (s)','+1');

        type_seed = spm_input('seed region time course','+1','b',{'File','Mask'},[1,0],2);
        if type_seed          
            SSF.seed = spm_select(1, 'any', 'select seed time course file', [], swd, '.*');
%             SSF.seed = load(seedfile);
        else
            SSF.seedmask = spm_select(1, 'IMAGE', 'select seed mask', [], swd, '.*');
%             SSF.seed = [];
        end
        SSF.titles{1} = 'seed';
        
        niCov = spm_input('Any other covariates? ','+1','y/n',[1,0],2);

        
        % --- Selecting the file with non-event covariates information--%  
        if niCov > 0
            [SSF.conf, swd] = spm_select(1, 'any', 'select non-event covariates file', [], swd, '.*');
            col_cof = load(SSF.conf);
            nIC = size(col_cof,2);
            for cv = 1:nIC
                SSF.titles{1+cv} = sprintf('confound %d ',cv);
            end
            SSF.titles{2+nIC} = 'intercept';
        else
            SSF.conf = [];
        end
        
        type_ROIm = spm_input('Apply ROI mask/label','+1','b',{'Mask','Label'},[1,0],2);
        if type_ROIm
            ROImask = spm_select(Inf, 'IMAGE', 'select ROI mask', [], swd, '.*');
            SSF.ROI.Mask = cellstr(ROImask);
        else
            SSF.ROI.Label = spm_select(1, 'IMAGE', 'select ROI label', [], swd, '.*');
            SSF.ROI.LabelVal = spm_input('Intested ROI label value','+1');
        end
        
%         nband = spm_input('How many bands? ','+1');
%         for k = 1:nband
        SSF.band{1} = spm_input('interested band points (1:floor(T/2)+1)','+1');
%         end
        
        SSF.nband = spm_input('number of bands','+1');   
        
        if spm_input('Apply between ROI correlation pattern? ','+1','y/n',[1 0],0)
            %%%%%%%%%%%% need to select .mat file
            SSF.Dpattern = spm_select(1, 'mat', 'select ROI correlation pattern .mat', [], swd, '.*');
        end
end

%----- brain mask -----% 
if spm_input('Apply a brain mask? ','+1','y/n',[1 0],0)
    SSF.mask = spm_select(1, 'IMAGE', 'select brain mask image', [], swd, '.*');
else
    SSF.mask = [];
    display('Note: Assume all ROI masks are inside the brain');
end

