
import gov.nih.mipav.plugins.*;
import gov.nih.mipav.view.*;
import gov.nih.mipav.model.structures.*;
import gov.nih.mipav.model.scripting.*;
import edu.jhmi.rad.medic.dialogs.*;

import java.awt.*;
import javax.swing.*;

/**
*   This is a plugin to compute TOADS (eXperimental version)
*
*   @see PlugInAlgorithm
*/

// This is a Algorithm type of PlugIn, and therefore must implement PlugInAlgorithm
// Implementing the PlugInAlgorithm requires this class to implement the run method
// with the correct parameters
public class PlugInDOTS implements PlugInAlgorithm {

    /**
    *   Defines body of run method, which was declared in the interface.
    *   This sample run method creates a new image in a new frame and
    *   calls methods in PlugInSampleDrawing to add a few VOIs.
    *
    *   @param  UI              User Interface
    *   @param  parentFrame     parent frame
    *   @param  image           current ModelImage - this is an image already
    *                           loaded into MIPAV. Can be null.
    *
    *   @see    ViewUserInterface
    *   @see    ModelImage
    *   @see    ViewJFrameImage
    */
    public void run(Frame parentFrame, ModelImage image) {

        if (parentFrame instanceof ViewJFrameImage)
            new JDialogDOTS(parentFrame, image);

        else
            MipavUtil.displayError ("PlugIn only runs on an image frame.");
    }

    public void run(Frame parentFrame, ModelImage imageA, ModelImage imageB) {

        if (parentFrame instanceof ViewJFrameImage)
            new JDialogDOTS(parentFrame, imageA);

        else
            MipavUtil.displayError ("PlugIn only runs on an image frame.");
    }
	public PlugInDOTS() {
		ScriptableActionLoader.addScriptActionLocation("edu.jhmi.rad.medic.dialogs.JDialog");
	}

}
