package edu.jhu.ece.iacl.plugins.dti;

import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.SpringLayout;
import javax.vecmath.Point3d;

import edu.jhmi.rad.medic.algorithms.AlgorithmDOTS;
import edu.jhmi.rad.medic.methods.DotsAtlas;

import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
//import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample;
//import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample.InterpolationMethod;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.MipavController;

import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.pipeline.view.input.ParamCollectionInputView;
import edu.jhu.ece.iacl.jist.pipeline.view.input.ParamCollectionPaneInputView;
import edu.jhu.ece.iacl.jist.pipeline.view.input.ParamCollectionWindowInputView;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipavWrapper;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataUByte;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;

import gov.nih.mipav.model.structures.ModelImage;
import gov.nih.mipav.model.structures.ModelStorageBase;
import gov.nih.mipav.view.MipavUtil;
import gov.nih.mipav.view.ViewJProgressBar;
import gov.nih.mipav.view.ViewUserInterface;
import gov.nih.mipav.view.dialogs.JDialogBase;

/**
 *   Medic wrapper for the release of Toads (atlas-based version)
 *
 *	@version    Feb 2009
 *	@author     Pilou Bazin
 */
public class MedicAlgorithmDOTS extends ProcessingAlgorithm {



	private ParamVolume inputImage;
	private ParamFile atlasFile;
	private ParamOption inputModality;
	
	//private ParamDouble isoDiffusion;
	//private ParamDouble gainFactor;
	
	private ParamInteger iterations;
	private ParamDouble maxDistance;
	private ParamInteger nbest;
	
	private ParamOption alignType;
	private ParamInteger alignIter;
	private ParamInteger initAlignIter;
	private ParamInteger levels;
	//private ParamDouble atlasScale;

	//private ParamOption outputType;
	private ParamVolume classification;
	private ParamVolume segmentation;
	private ParamVolume memberships;
	
	private ParamVolume lesionMask;
	private ParamOption lesionMaskType;
	
	private ParamCollection mainParams;
	private ParamCollection advParams;
		
	private static final String cvsversion = "$Revision: 1.3 $";
	public static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	
	/**
	 * Create Input parameters as specified in AlgorithmDTITractSegmentation. The
	 * boundaries for these variables do not necessarily match those specified
	 * in the original dialog
	 */
	protected void createInputParameters(ParamCollection inputParams) {
		
		AlgorithmInformation info = getAlgorithmInformation();
		info.add(PrinceGroupAuthors.pierreLouisBazin);
		info.setDescription("Algorithm for atomated white matter tract segentation in Diffusion MRI");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
		//info.add(new Citation("Bazin PL, "));

		
		inputImage = new ParamVolume("Image to segment");
		inputImage.setDescription("3D MRI Volume");
		
		String[] modal = {"TensorD_(xx,yy,zz,xy,yz,zx)","TensorT_(xx,xy,xz,yy,yz,zz)","TensorLT_(xx,yx,yy,zx,zy,zz)",
									"FA+dir_(FA,x,y,z)"};
		inputModality=new ParamOption("Image type",modal);
		inputModality.setDescription("DTI image type");
		
		atlasFile = new ParamFile("Atlas file",new FileExtensionFilter(new String[]{"txt"}));
		
		String defaultAtlasName = "Atlas/dots-atlas-2010/dots-wm-atlas.txt";
		try {
			ClassLoader cl = Thread.currentThread().getContextClassLoader();
			atlasFile.setValue(cl.getResource(defaultAtlasName).getFile());
		} catch (Exception e) {
			System.err.print("Error: Unable to set default atlas\n");
		}
//		URL res = MedicAlgorithmDTITractSegmentation.class.getResource(filename);
		
		//default atlasfile is to be added
//		atlasFile.setValue(res.getFile());
		atlasFile.setDescription("Atlas Description File, containing default parameters and atlas path.");
		
		/*
		isoDiffusion = new ParamDouble("Isotropic diffusion", 0, 1E10);
		isoDiffusion.setValue(0.02);
		gainFactor = new ParamDouble("Normalization factor", 0, 1E10);
		gainFactor.setValue(0.02);
		*/
		
		iterations = new ParamInteger("Maximum iterations", 0, 100000);
		iterations.setValue(50);
		
		maxDistance = new ParamDouble("Maximum distance", 0, 1E10);
		maxDistance.setValue(0.01);
		
		nbest = new ParamInteger("Overlapping probability number", 0, 100);
		nbest.setValue(8);
		
		String[] align = {"rigid","single_scale","scaled_rigid","fully_affine",
							"multi_rigid","multi_single_scale","multi_scaled_rigid","multi_fully_affine"};
		alignType=new ParamOption("Alignment type",align);
		alignType.setValue("rigid");
		
		alignIter = new ParamInteger("Alignment iterations", 0, 100000);
		alignIter.setValue(5);
		initAlignIter = new ParamInteger("Initial alignment iterations", 0, 100000);
		initAlignIter.setValue(50);
		levels = new ParamInteger("Initial alignment levels", 0, 100000);
		levels.setValue(4);
		/*
		atlasScale = new ParamDouble("Atlas scale", 0, 1E10);
		atlasScale.setValue(1.0);
		*/
		
		/*
		String[] out = {"hard_segmentation","full_segmentation"};
		outputType=new ParamOption("Output images", out);
		outputType.setValue("full_segmentation");
		*/
		
		String[] les = {"none","lesions"};
		lesionMaskType=new ParamOption("optional mask", les);
		lesionMaskType.setValue("none");
		
		lesionMask = new ParamVolume("Lesion mask (optional)");
		lesionMask.setDescription("3D MRI Volume of segmented WM lesions");
		lesionMask.setMandatory(false);		
		
		mainParams=new ParamCollection("Main");
		// Add input to main panel
		mainParams.add(inputImage);
		mainParams.add(inputModality);
		mainParams.add(atlasFile);
		//mainParams.add(outputType);
		
		advParams=new ParamCollection("Parameters");
		
		//advParams.add(isoDiffusion);
		//advParams.add(gainFactor);
		advParams.add(iterations);
		advParams.add(maxDistance);
		advParams.add(nbest);
		advParams.add(alignType);
		advParams.add(alignIter);
		advParams.add(initAlignIter);
		advParams.add(levels);
		//advParams.add(atlasScale);
		advParams.add(lesionMaskType);
		advParams.add(lesionMask);
		
		inputParams.add(mainParams);
		inputParams.add(advParams);
		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI");
		inputParams.setName("DOTS");
		inputParams.setLabel("DOTS: Diffusion Oriented Tract Segmentation");
	}

	/**
	 * Create output Parameters for TOADS. Note: Not all output fields are
	 * populated and the non-populated fields will create an error that is
	 * caught by the dialog.
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
		// not working; is it set before the input parameters are received ??
		
		outputParams.add(classification = new ParamVolume("Hard segmentation"));
		outputParams.add(segmentation = new ParamVolume("Tract segmentations",VoxelType.BOOLEAN,-1,-1,-1,-1));
		outputParams.add(memberships = new ParamVolume("Membership Functions",VoxelType.FLOAT,-1,-1,-1,-1));
		classification.setMandatory(false);
		segmentation.setMandatory(false);
		memberships.setMandatory(false);
	}

	/**
	 * Execute the algorithm given the input parameters
	 */
	protected class DOTSWrapper extends AbstractCalculation{
		public DOTSWrapper(){
			setLabel("DOTS");
		}
		public void execute(){
			
			// get the ModelImage needed by the algorithm
			ModelImage[] images = new ModelImage[1];
			images[0] = inputImage.getImageData().getModelImageCopy();
			
			String[] modals = new String[1];
			modals[0] = inputModality.getValue();
			
			System.out.println("ATLAS FILE "+atlasFile.getValue().getAbsolutePath());
			DotsAtlas atlas = new DotsAtlas(atlasFile.getValue().getAbsolutePath());
			
			ModelImage lesions = null;
			if (!lesionMaskType.getValue().equals("none")) {
				lesions = lesionMask.getImageData().getModelImageCopy();
			}
			
			setTotalUnits(1);
			
			AlgorithmDOTSWrapper algo = new AlgorithmDOTSWrapper(images, 1, modals, 
									  atlasFile.getValue().getAbsolutePath(), atlas, "full_segmentation", 
									  lesions, lesionMaskType.getValue(),
									  -1, -1, 
									  iterations.getInt(), maxDistance.getFloat(), nbest.getInt(), 
									  alignType.getValue(), 
									  3.0f, 
									  levels.getInt(), initAlignIter.getInt(), alignIter.getInt()
									  );
			algo.setObserver(this);
			algo.runAlgorithm();
			
			ModelImage[] resultImage=algo.getResultImages();
			/*
			for(ModelImage img:resultImage){
				if(img.getExtents().length<4||img.getExtents()[3]==1){
					img.copyFileTypeInfo(images[0]);
				} else {
					img.copyFileTypeInfo(images[0]);
				}
			}
			*/
			
			// export the images needed
			/*
			if (outputType.getValue().equals("hard_segmentation")) {
				System.out.println("Output: hard segmentation ("+resultImage.length+")");
				ImageData res = new ImageDataMipavWrapper(resultImage[0]);
				res.setHeader(inputImage.getImageData().getHeader());
				classification.setValue(res);
			} else if (outputType.getValue().equals("full_segmentation")) {
			*/
				System.out.println("Output: full segmentation ("+resultImage.length+")");
				ImageData res = new ImageDataMipavWrapper(resultImage[0]);
				res.setHeader(inputImage.getImageData().getHeader());
				classification.setValue(res);
				res = new ImageDataMipavWrapper(resultImage[1]);
				res.setHeader(inputImage.getImageData().getHeader());
				segmentation.setValue(res);
				res = new ImageDataMipavWrapper(resultImage[2]);
				res.setHeader(inputImage.getImageData().getHeader());
				memberships.setValue(res);
			//}	
			
			images[0].disposeLocal();
			markCompleted();
		}
	}
	protected class AlgorithmDOTSWrapper extends AlgorithmDOTS{
		protected AbstractCalculation observer;
		public AlgorithmDOTSWrapper(ModelImage[] srcImg_, int nInput_,
											String[] imgModal_,
											String aName_, DotsAtlas atlas_, String segOutput_, 
											ModelImage labeling_, String lbType_,
											float isoDiff_, float gainF_,
											int iterMax_, float distMax_, int nbest_,
											String alignT_,
											float aScale_,
											int lev_, int initR_, int iterR_) {
			super(srcImg_, nInput_, imgModal_, aName_, atlas_, segOutput_, 
											labeling_, lbType_,
											isoDiff_, gainF_,
											iterMax_, distMax_, nbest_,
											alignT_,
											aScale_,
											lev_, initR_, iterR_);
		}
		public void setObserver(AbstractCalculation observer) {
			this.observer=observer;
		}
		public void runAlgorithm(){
			observer.setTotalUnits(100);
			super.runAlgorithm();
			observer.markCompleted();
		}
	    /**
	     * Notifies all listeners that have registered interest for notification on this event type.
	     *
	     * @param  value  the value of the progress bar.
	     */
	    protected void fireProgressStateChanged(int value) {
	        super.fireProgressStateChanged(value);
	        observer.setCompletedUnits(value);
	    }

	    /**
	     * Updates listeners of progress status. Without actually changing the numerical value
	     *
	     * @param  imageName  the name of the image
	     * @param  message    the new message to display
	     */
	    protected void fireProgressStateChanged(String imageName, String message) {
	    	super.fireProgressStateChanged(imageName, message);
	    	observer.setLabel(message);
	    }
	}
	protected void execute(CalculationMonitor monitor) {
		DOTSWrapper dtiseg=new DOTSWrapper();
		monitor.observe(dtiseg);
		dtiseg.execute();
	}
	public Dimension getPreferredSize() {
		return new Dimension(300,450);
	}
}
