package edu.jhu.ece.iacl.plugins.dti;

import edu.jhu.ece.iacl.jist.io.FiberCollectionReaderWriter;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.structures.fiber.FiberCollection;
import edu.jhu.ece.iacl.jist.structures.fiber.Fiber;
import edu.jhu.ece.iacl.jist.structures.fiber.XYZ;
import edu.jhu.ece.iacl.jist.structures.geom.CurveCollection;

import java.io.BufferedInputStream;  
import java.io.BufferedOutputStream;  
import java.io.DataInputStream;  
import java.io.DataOutputStream;  
import java.io.File;
import java.io.FileInputStream;  
import java.io.FileOutputStream; 
import java.io.IOException;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

public class MedicAlgorithmFibersToTRK extends ProcessingAlgorithm {
	//input params
	private ParamObject<FiberCollection> fibersdat;
	private ParamFile fiberstrk;

	private ParamOption conversion;
	//private ParamOption endian;
	//ouputparams
	private ParamFile fiberstrkout;
	private ParamObject<FiberCollection> fibersdatout;

	private FiberCollectionReaderWriter fcrw = FiberCollectionReaderWriter.getInstance();

	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Converts a FiberCollection to TRK format.";
	private static final String longDescription = "";


	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(fibersdat=new ParamObject<FiberCollection>("Input DAT Fibers",new FiberCollectionReaderWriter()));
		//fibersdat.setMandatory(false);
		//inputParams.add(fiberstrk=new ParamFile("Input TRK Fibers",new FileExtensionFilter(new String[]{"trk"})));
//		fiberstrk.setMandatory(false);

		//String[] sel = {"TRK to DAT","DAT to TRK"};
		//inputParams.add(conversion=new ParamOption("Convertion Type", sel));
		//conversion.setValue("TRK to DAT");

//		String[] endiansel = {"Yes","No"};
//		inputParams.add(endian=new ParamOption("Endian Conversion", endiansel));
//		endian.setValue("Yes");

		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI");
		inputParams.setLabel("TRK DAT Conversion");
		inputParams.setName("TRK_DAT_Conversion");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("");
		info.setAffiliation("Johns Hopkins University, Departments of Electrical and Computer Engineering");
		info.add(new AlgorithmAuthor("Chuyang Ye","cye4@jhu.edu",""));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(fiberstrkout = new ParamFile("Ouput TRK Fibers",new FileExtensionFilter(new String[]{"trk","dat"})) );
		//fiberstrkout.setMandatory(false);
		/*outputParams.add(fibersdatout = new ParamObject<FiberCollection>("Output DAT Fibers",new FiberCollectionReaderWriter()) );
		fibersdatout.setMandatory(false);	*/
	}


	@Override
	protected void execute(CalculationMonitor monitor)
	throws AlgorithmRuntimeException {
		System.out.println("Processing Started");
		File dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){
			e.printStackTrace();
		}

		System.out.println("DAT to TRK");
		String fileName = dir + File.separator + fibersdat.getObject().getName()+".trk";  

		FiberCollection fiber = fibersdat.getObject();
		Point3f res = fiber.getResolutions();
		Point3i dim = fiber.getDimensions();
		try  
		{  
			DataOutputStream out=new DataOutputStream(  
					new BufferedOutputStream(  
							new FileOutputStream(fileName))); 
			byte[] id_string = new byte[6];
			char[] id_char = {'T','R','A','C','K',0};
			for(int i = 0; i < 6; i++){
				id_string[i] = (byte) id_char[i];
			}
			out.write(id_string);
			System.out.println(out.size()+" bytes have been written.");  

			short x = (short)dim.x;
			short y = (short)dim.y;
			short z = (short)dim.z;
			out.writeShort(swap(x));
			out.writeShort(swap(y));
			out.writeShort(swap(z));
			System.out.println("dimension written");
			System.out.println(out.size()+" bytes have been written."); 

			out.writeFloat(swap(res.x));
			out.writeFloat(swap(res.y));
			out.writeFloat(swap(res.z));
			System.out.println("resolution written");
			System.out.println(out.size()+" bytes have been written."); 

			out.writeFloat(swap(0.0f));
			out.writeFloat(swap(0.0f));
			out.writeFloat(swap(0.0f));
			System.out.println("origin written");
			System.out.println(out.size()+" bytes have been written."); 

			out.writeShort(swap(0));
			System.out.println("n_s written");
			System.out.println(out.size()+" bytes have been written."); 

			byte[] nsname = new byte[200];
			char[] nsname_char = new char[200];
			for(int i = 0; i < 200; i++){
				nsname_char[i] = ' ';
				nsname[i] = (byte)nsname_char[i];
			}
			out.write(nsname);
			System.out.println("n_s names written");
			System.out.println(out.size()+" bytes have been written."); 

			out.writeShort(swap(0));
			System.out.println("n_p written");
			System.out.println(out.size()+" bytes have been written."); 

			byte[] npname = new byte[200];
			char[] npname_char = new char[200];
			for(int i = 0; i < 200; i++){
				npname_char[i] = ' ';
				npname[i] = (byte)npname_char[i];
			}
			out.write(npname);
			System.out.println("n_p names written");
			System.out.println(out.size()+" bytes have been written."); 

			for(int i = 0; i < 16; i++){
				out.writeFloat(swap(0.0f));
			}
			System.out.println("RAS written");
			System.out.println(out.size()+" bytes have been written."); 

			byte[] reserved = new byte[444];
			char[] reserved_char = new char[444];
			for(int i = 0; i < 444; i++){
				reserved_char[i] = ' ';
				reserved[i] = (byte)reserved_char[i];
			}
			out.write(reserved);
			System.out.println("reserved written");
			System.out.println(out.size()+" bytes have been written."); 

			char[] voxel_order = {'L','P','S',0};//temp
			byte[] vox_order = new byte[4];
			for(int i = 0; i < 4; i++){
				vox_order[i] = (byte)voxel_order[i];
			}
			//char[] voxel_order = str.toCharArray();
			out.write(vox_order);

			System.out.println("voxel order written");
			System.out.println(out.size()+" bytes have been written."); 

			char[] pad2_char = {'L','P','S',0};
			byte[] pad2 = new byte[4];
			for(int i = 0; i < 4; i++){
				pad2[i] = (byte)pad2_char[i];
			}
			//char [] pad2 = str.toCharArray();
			out.write(pad2);

			System.out.println("paddings 2 written");
			System.out.println(out.size()+" bytes have been written."); 

			float[] image_orientation_patient = new float[6];
			for(int i = 0; i < 6; i++){
				out.writeFloat(swap(image_orientation_patient[i]));
			}
			System.out.println("orientation written");
			System.out.println(out.size()+" bytes have been written."); 

			char[] pad1_char = {0,0};
			byte[] pad1 = new byte[2];
			for(int i = 0; i < 2; i++){
				pad1[i] = (byte)pad1_char[i];
			}
			out.write(pad1);
			System.out.println("paddings 1 written");
			System.out.println(out.size()+" bytes have been written."); 

			//char[] invert_char = {0,0,0};
			byte[] invert = {0,0,0};
			out.write(invert);
			System.out.println("invert written");
			System.out.println(out.size()+" bytes have been written."); 

			byte[] swapb = {0,0,0};
			out.write(swapb);
			System.out.println("swap written");
			System.out.println(out.size()+" bytes have been written."); 

			int n_count = fiber.size();
			out.writeInt(swap(n_count));
			System.out.println("n_count written");
			System.out.println(out.size()+" bytes have been written."); 

			int version = 2;
			out.writeInt(swap(version));
			System.out.println("version written");
			System.out.println(out.size()+" bytes have been written."); 

			int hdr_size = 1000;
			out.writeInt(swap(hdr_size));
			System.out.println("hdr_size written");
			System.out.println(out.size()+" bytes have been written."); 

			for(int i = 0; i < n_count; i++){
				XYZ[] chain = fiber.get(i).getChain();
				System.out.println(i+" "+chain.length);
				out.writeInt(swap(chain.length));
				for(XYZ pt : chain){
					System.out.println(pt.x+" "+pt.y+" "+pt.z);
					int itemp;
					byte[] temp = new byte[4];
					itemp = Float.floatToIntBits(pt.x*res.x);

					for(int k = 0;k < 4; k++){
						temp[3-k] = (byte)(itemp >> (24- k*8));
					}
					out.write(temp);
					itemp = Float.floatToIntBits(pt.y*res.y);

					for(int k = 0;k < 4; k++){
						temp[3-k] = (byte)(itemp >> (24- k*8));
					}
					out.write(temp);
					itemp = Float.floatToIntBits(pt.z*res.z);

					for(int k = 0;k < 4; k++){
						temp[3-k] = (byte)(itemp >> (24- k*8));
					}
					out.write(temp);

				}
			}

			out.close();  
			fiberstrkout.setValue(fileName);
		} 
		catch (Exception e)  
		{  
			e.printStackTrace();  
		}  

		fiberstrkout.setValue(fileName);

	}

	/*		else{
			FiberCollection fibers = new FiberCollection();
			//int sum = 0;
			try  
			{  
				System.out.println(fiberstrk.getValue());
				File trkName = fiberstrk.getValue(); 
				DataInputStream in=new DataInputStream(  
						new BufferedInputStream(  
								new FileInputStream(trkName))); 
				String fileName = dir + File.separator + fiberstrk.getValue().getName().substring(0, fiberstrk.getValue().getName().length()-4) + "_test.trk"; 
//				DataOutputStream out=new DataOutputStream(  
//						new BufferedOutputStream(  
//								new FileOutputStream(fileName)));  

				byte[] id_string = new byte[6];
				for(int i = 0; i < 6; i++){
					id_string[i] = in.readByte();
					//sum = sum + 1;
					//System.out.print(id_string[i]+" ");
				}

				System.out.println("id_string: "+ new String(id_string));
				//out.write(id_string);
				//System.out.println("size: " + out.size());

				Point3i dim = new Point3i();
				short tempx = in.readShort();
				short tempy = in.readShort();
				short tempz = in.readShort();

				//System.out.println("dim: " + tempx +" " + tempy + " " + tempz);
				dim.x = (int)swap(tempx);
				dim.y = (int)swap(tempy);
				dim.z = (int)swap(tempz);

				//sum = sum + 6;
				System.out.println("dim: " + dim.x +" " + dim.y + " " + dim.z);
				//out.writeShort(dim.x);
				//out.writeShort(dim.y);
				//out.writeShort(dim.z);
				//System.out.println("size: " + out.size());
				fibers.setDimensions(dim);

				Point3f res = new Point3f();
				res.x = in.readFloat();
				res.y = in.readFloat();
				res.z = in.readFloat();
				//sum = sum + 12;
				//System.out.println("res: " + res.x + " " + res.y + " " + res.z); 
				res.x = swap(res.x);
				res.y = swap(res.y);
				res.z = swap(res.z);
				System.out.println("res: " + res.x + " " + res.y + " " + res.z); 
				fibers.setResolutions(res);
//				out.writeFloat(res.x);
//				out.writeFloat(res.y);
//				out.writeFloat(res.z);
//				System.out.println("size: " + out.size());

				float[] origin = new float[3];
				origin[0] = swap(in.readFloat());
				origin[1] = swap(in.readFloat());
				origin[2] = swap(in.readFloat());
				//sum = sum + 12;
				System.out.println("origin: " + origin[0] + " " + origin[1] + " " + origin[2]);
//				out.writeFloat(origin[0]);
//				out.writeFloat(origin[1]);
//				out.writeFloat(origin[2]);
//				System.out.println("size: " + out.size());

				int n_s = swap(in.readShort());
				//sum = sum + 2;
				System.out.println("n_s: " + n_s);
//				out.writeShort(n_s);
//				System.out.println("size: " + out.size());

				//String n_s_name = new String();
				byte[] nsname = new byte[200];
				for(int i = 0; i < 200; i++){
					nsname[i] = in.readByte();
					//sum = sum + 1;
				}
				//String n_sname = nsname.toString();
				System.out.println("n_s names: " + new String(nsname));
//				out.write(nsname);
//				System.out.println("size: " + out.size());


				int n_p = swap(in.readShort());
				//sum = sum + 2;
				System.out.println("n_p: " + n_p);
//				out.writeShort(n_p);
//				System.out.println("size: " + out.size());

				byte[] npname = new byte[200];
				for(int i = 0; i < 200; i++){
					npname[i] = in.readByte();
					//sum = sum + 1;
				}
				String n_pname = npname.toString();
				System.out.println("n_p names: " + new String(npname));
//				out.write(npname);
//				System.out.println("size: " + out.size());

				System.out.println("RAS: ");
				float[][] RAS = new float[4][4];
				for(int i = 0; i < 4; i++){
					for(int j = 0; j < 4; j++){
						RAS[i][j] = swap(in.readFloat());
//						sum = sum + 4;
						System.out.print(RAS[i][j]+" ");
//						out.writeFloat(RAS[i][j]);

					}
					System.out.print("\n");
				}
//				System.out.println("size: " + out.size());


				byte[] reserved = new byte[444];
				for(int i = 0; i < 444; i++){
					reserved[i] = in.readByte();
//					sum = sum + 1;
				}

				System.out.println("reserved: " + new String(reserved));
//				out.write(reserved);
//				System.out.println("size: " + out.size());

				byte[] vox_order = new byte[4];
				for(int i = 0; i < 4; i++){
					vox_order[i] = in.readByte();
//					sum = sum + 1;
					System.out.print(vox_order[i]+" ");
				}
				System.out.println("voxel order: " + new String(vox_order));
//				out.write(vox_order);
//				System.out.println("size: " + out.size());

				byte[] pad2 = new byte[4];
				for(int i = 0; i < 4; i++){
					pad2[i] = in.readByte();
//					sum = sum + 1;
					System.out.print(pad2[i]+" ");
				}
				System.out.println("pad2: " + new String(pad2));
//				out.write(pad2);
//				System.out.println("size: " + out.size());


				float[] image_orientation_patient = new float[6];
				for(int i = 0; i < 6; i++){
					image_orientation_patient[i] = swap(in.readFloat());
//					out.writeFloat(image_orientation_patient[i]);
//					sum = sum + 4;
				}
				System.out.println("image orientation patient: " + image_orientation_patient[0] + " "+
						image_orientation_patient[1] + " " + image_orientation_patient[2] + " " + 
						image_orientation_patient[3] + " " + image_orientation_patient[4] + " " +
						image_orientation_patient[5]);
//				System.out.println("size: " + out.size());

				byte[] pad1 = new byte[2];
				for(int i = 0; i < 2; i++){
					pad1[i] = in.readByte();
//					sum = sum + 1;
					System.out.print(pad1[i]+" ");
				}
				System.out.println("pad1: " + new String(pad1));
//				out.write(pad1);
//				System.out.println("size: " + out.size());

				byte[] invert = new byte[3];
				byte invert_x = in.readByte();
				invert[0] = invert_x;
				byte invert_y = in.readByte();
				invert[1] = invert_y;
				byte invert_z = in.readByte();
				invert[2] = invert_z;

//				sum = sum + 3;
				System.out.println("invert: " + invert_x + " " + invert_y + " " + invert_z +"; "+ (char)invert_x + " " + (char)invert_y + " " + (char)invert_z);
//				out.write(invert);
//				System.out.println("size: " + out.size());

				byte[] swap = new byte[3];
				byte swap_xy = in.readByte();
				swap[0] = swap_xy;
				byte swap_yz = in.readByte();
				swap[1] = swap_yz;
				byte swap_zx = in.readByte();
				swap[2] = swap_zx;
//				sum = sum + 3;
				System.out.println("swap: " + swap_xy + " " + swap_yz + " " + swap_zx + "; " + (char)swap_xy + " " + (char)swap_yz + " " + (char)swap_zx);
//				out.write(swap);
//				System.out.println("size: " + out.size());

				int n_count = swap(in.readInt());
//				sum = sum + 4;
				System.out.println("n_count: " + n_count);
//				out.writeInt(n_count);
//				System.out.println("size: " + out.size());

				int version = swap(in.readInt());
//				sum = sum + 4;
				System.out.println("version: " + version);
//				out.writeInt(version);
//				System.out.println("size: " + out.size());

				int hdr_size = swap(in.readInt());
//				sum = sum + 4;
				System.out.println("hdr_size: " + hdr_size);
//				out.writeInt(hdr_size);
//				System.out.println("size: " + out.size());

//				System.out.println("sum of input: " + sum);
//				out.close();
				for(int i = 0; i < n_count; i++){
					//System.out.println("i: "+i);
					int points = swap(in.readInt());
					System.out.println(i + points);
					XYZ[] chain = new XYZ[points];

					for(int j = 0; j < points ;j++){
						//System.out.println("j: "+j);
						float x = swap(in.readFloat());
						float y = swap(in.readFloat());
						float z = swap(in.readFloat());
						System.out.println(x+" "+y+" "+z);
						chain[j] = new XYZ();
						chain[j].x = x;
						chain[j].y = y;
						chain[j].z = z;
						for(int k = 0; k < n_s; k++){
							float temp = swap(in.readFloat());
						}
					}

					for(int k = 0; k < n_p; k++){
						float temp = swap(in.readFloat());
					}
					Fiber f = new Fiber(chain);
					fibers.add(f);

				}

				in.close();  

				fibers.setName(fiberstrk.getValue().getName().substring(0, fiberstrk.getValue().getName().length()-4));

				System.out.println(dir);
				//File fdat = fcrw.write(fibers, dir);
				fibersdatout.setObject(fibers);
				//fibersdatout.setValue(fdat);
			}
			catch (Exception e)  
			{  
				e.printStackTrace();  
			}  


		}*/


	public static short swap(short input){
		short out = (short)(((input & 0xff)<<8)|((input >> 8) & 0xff)<<0);
		return out;
	}
	public static int swap(int input){
		int out = ((input >>  0) & 0xff)<<24 | ((input >>  8) & 0xff)<<16 | 
		((input >> 16) & 0xff)<<8 | ((input >> 24) & 0xff)<<0;
		return out;
	}
	public static float swap(float input){
		int intValue = Float.floatToIntBits (input);
		intValue = swap (intValue);
		return Float.intBitsToFloat (intValue);
	}

	public static long swap (long value)
	{
		long b1 = (value >>  0) & 0xff;
		long b2 = (value >>  8) & 0xff;
		long b3 = (value >> 16) & 0xff;
		long b4 = (value >> 24) & 0xff;
		long b5 = (value >> 32) & 0xff;
		long b6 = (value >> 40) & 0xff;
		long b7 = (value >> 48) & 0xff;
		long b8 = (value >> 56) & 0xff;

		return b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 |
		b5 << 24 | b6 << 16 | b7 <<  8 | b8 <<  0;
	}
	public static double swap (double value)
	{
		long longValue = Double.doubleToLongBits (value);
		longValue = swap (longValue);
		return Double.longBitsToDouble (longValue);
	}

}
