# POWERCRUST_PATH = path to the source of the fim library

file(GLOB POWERCRUST_INCL_PATH_1 "../powercrust*")
set(POWERCRUST_INCL_PATHS ${POWERCRUST_INCL_PATH_1})

find_path(POWERCRUST_PATH vtkPowerCrustSurfaceReconstruction.h ${POWERCRUST_INCL_PATHS})       

if (POWERCRUST_PATH)
  set(POWERCRUST_FOUND TRUE)
  find_path(POWERCRUST_INCLUDE vtkPowerCrustSurfaceReconstruction.h ${POWERCRUST_PATH})
  find_library(POWERCRUST_LIB powercrust ${POWERCRUST_PATH}/lib)
endif(POWERCRUST_PATH)

IF (POWERCRUST_FOUND)
    MESSAGE(STATUS "Found POWERCRUST: ${POWERCRUST_LIBRARY}")
ELSE (POWERCRUST_FOUND)
  IF (POWERCRUST_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find POWERCRUST.")
  ENDIF (POWERCRUST_FIND_REQUIRED)
ENDIF (POWERCRUST_FOUND)
