/*******************************************************

This program calculates the mean of classification scores output from a serial of classifiers with different numbers of features.

last modified : Oct 6, 2008

yong.fan@ieee.org
kanterae@uphs.upenn.edu

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <getopt.h>

#define EXEC_NAME "COMPARE_score_mean"

#ifndef RELEASE_ID
#define RELEASE_ID "0.0_super_alpha"
#endif

#define SVNFILEVER "$Id: COMPARE_score_mean.cc 17 2008-10-08 17:27:42Z kanterae $"

#ifndef SVN_REV
#define SVN_REV "NO_SVN" 
#endif


void version(){
  printf("\n\n%s Version information\n",EXEC_NAME);
  printf("  Release          : %s\n", RELEASE_ID);
  printf("  Svn Revision     : %s\n", SVN_REV);
  printf("  Svn File Version : %s\n", SVNFILEVER);
}

void usage(){
  printf("\n This program calculates the mean of classification scores output from a serial of classifiers with different numbers of features.\n");

  printf("\n Usage: %s (output) (input_scores) (num_subject) (num_feature)",EXEC_NAME);
  printf("\n Usage: %s [-u/h/v]\n",EXEC_NAME);
  
  printf("\n Required arguments:");
  printf("\n   output        : output filename");
  printf("\n   input_scores  : input classification scores to be divided by \"num_feature\"");
  printf("\n   num_subject   : number of scores to read in from input");
  printf("\n   num_feature   : number of features to divide the scores by\n");
  
  printf("\n Optional arguments:\n");
  printf("\n   [-u      --usage]     Display this message");
  printf("\n   [-h       --help]     Display this message");
  printf("\n   [-v    --version]     Display version information\n");
  
  printf("\n More information:");
  printf("\n   https://www.rad.upenn.edu/sbia/software/");
  printf("\n   sbia-software@uphs.upenn.edu");
  printf("\n\n");
}

int main(int argc, char *argv[])
{

  static struct option long_options[] =
  {
    {"usage",       no_argument,            0, 'u'},
    {"help",        no_argument,            0, 'h'},
    {"version",     no_argument,            0, 'v'},
  };

  int c, option_index = 0;

  if(argc!=5){
    while ( (c = getopt_long (argc, argv, "uhv",
                long_options,&option_index)) != -1){
      switch (c)
      {
        case 'v':
          version();
          return 0;

        case 'u':
          usage();
          return 0;

        case 'h':
          usage();
          return 0;

        case '?':
          /* getopt_long already printed an error message. */
          break;

        default:
          return 1;
      }
    }
    usage();
    exit(1);
  }

  char* input_file1 = argv[1];
  char* input_file2 = argv[2];
  int num_subject   = atoi(argv[3]);
  int num_feature   = atoi(argv[4]);

  FILE *fp1, *fp2;
  
  if((fp1=fopen(input_file1,"w"))==NULL)
    {
      printf("\n cannot open file %s.\n",input_file1);
      exit(1);
    }
  if((fp2=fopen(input_file2,"r"))==NULL)
    {
      printf("\n cannot open file %s.\n",input_file2);
      exit(1);
    }
  
  float tmp;
  for(int i=0; i<num_subject; i++)
    {
      fscanf(fp2,"%f",&tmp);
      fprintf(fp1,"%f\n",tmp/num_feature);
    }
  fclose(fp1);
  fclose(fp2);
  
  return 0;
}
