/*******************************************************

This program calculates sum of spatial discrinination maps when different numbers of features were used to build the classifier.

last modified : Oct 6, 2008

yong.fan@ieee.org
kanterae@uphs.upenn.edu

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "nrutil_compare.h"
#include <getopt.h>

#define EXEC_NAME "COMPARE_float_sum_m"

#ifndef RELEASE_ID
#define RELEASE_ID "0.2.1"
#endif

#define SVNFILEVER "$Id: COMPARE_float_sum_m.cc 17 2008-10-08 17:27:42Z kanterae $"

#ifndef SVN_REV
#define SVN_REV "NO_SVN" 
#endif


void version(){
  printf("\n\n%s Version information\n",EXEC_NAME);
  printf("  Release          : %s\n", RELEASE_ID);
  printf("  Svn Revision     : %s\n", SVN_REV);
  printf("  Svn File Version : %s\n", SVNFILEVER);
}

void usage(){
  printf("\n This program calculates sum of spatial discrinination maps when different numbers of features were used to build the classifier.\n");

  printf("\n Usage: %s (input_file1) (input_file2) (xdim) (ydim) (zdim)",EXEC_NAME);
  printf("\n Usage: %s [-u/h/v]\n",EXEC_NAME);
  
  printf("\n Required arguments:");
  printf("\n   input_file1    : first map to sum");
  printf("\n   input_file2    : second map to sum (will be overwritten with the summed output!)");
  printf("\n   xdim           : x dimention of map");
  printf("\n   ydim           : y dimention of map");
  printf("\n   zdim           : z dimention of map\n");
  
  printf("\n Optional arguments:\n");
  printf("\n   [-u      --usage]     Display this message");
  printf("\n   [-h       --help]     Display this message");
  printf("\n   [-v    --version]     Display version information\n");
  
  printf("\n More information:");
  printf("\n   https://www.rad.upenn.edu/sbia/software/");
  printf("\n   sbia-software@uphs.upenn.edu");
  printf("\n\n");
}

int main(int argc, char *argv[])
{

  static struct option long_options[] =
  {
    {"usage",       no_argument,            0, 'u'},
    {"help",        no_argument,            0, 'h'},
    {"version",     no_argument,            0, 'v'},
  };

  int c, option_index = 0;

  if(argc!=6){
    while ( (c = getopt_long (argc, argv, "uhv",
                long_options,&option_index)) != -1){
      switch (c)
      {
        case 'v':
          version();
          return 0;

        case 'u':
          usage();
          return 0;

        case 'h':
          usage();
          return 0;

        case '?':
          /* getopt_long already printed an error message. */
          break;

        default:
          return 1;
      }
    }
    usage();
    exit(1);
  }
  
  char *input_file1 = argv[1];
  char *input_file2 = argv[2];
  int  xdim = atoi(argv[3]);
  int  ydim = atoi(argv[4]);
  int  zdim = atoi(argv[5]);

  printf("\n The input options are below:");
  printf("\n input_file1:  %s",input_file1);
  printf("\n input_file2:  %s",input_file2);
  printf("\n xdim:         %d",xdim);
  printf("\n ydim:         %d",ydim);
  printf("\n zdim:         %d",zdim);
  printf("\n ======================================\n");

  float ***im = f3tensor(xdim,ydim,zdim);

  FILE *fp1,*fp2;
  if((fp1=fopen(input_file1,"r"))==NULL)
    { 
      printf("\n Cannot open file %s\n",input_file1);
      exit(1);
    }
  if((fp2=fopen(input_file2,"r"))==NULL)
    { 
      printf("\n Cannot open file %s\n",input_file2);
      exit(1);
    }

  float tmp;
  for(int k=0; k<zdim; k++)
    for(int j=0; j<ydim; j++)
      for(int i=0; i<xdim; i++)
	{
	  fread(&tmp,sizeof(float),1,fp1);
	  fread(&im[i][j][k],sizeof(float),1,fp2);
	  im[i][j][k] += tmp;
	}
  fclose(fp1);
  fclose(fp2);
  
  if((fp2=fopen(input_file2,"w"))==NULL)
    { 
      printf("\n Cannot open file %s\n",input_file2);
      exit(1);
    }
  for(int k=0; k<zdim; k++)
    for(int j=0; j<ydim; j++)
      for(int i=0; i<xdim; i++)
	fwrite(&im[i][j][k],sizeof(float),1,fp2);
  fclose(fp2);


  free_f3tensor(im,xdim,ydim,zdim);
  return 0;
}
