/*******************************************************

This program calculates sum of classification scores output from a serial of classifiers with different numbers of features.

last modified : Oct 6, 2008

yong.fan@ieee.org
kanterae@uphs.upenn.edu

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <getopt.h>

#define EXEC_NAME "COMPARE_score_sum"

#ifndef RELEASE_ID
#define RELEASE_ID "0.2.1"
#endif

#define SVNFILEVER "$Id: COMPARE_score_sum.cc 17 2008-10-08 17:27:42Z kanterae $"

#ifndef SVN_REV
#define SVN_REV "NO_SVN" 
#endif


void version(){
  printf("\n\n%s Version information\n",EXEC_NAME);
  printf("  Release          : %s\n", RELEASE_ID);
  printf("  Svn Revision     : %s\n", SVN_REV);
  printf("  Svn File Version : %s\n", SVNFILEVER);
}

void usage(){
  printf("\n This program calculates sum of classification scores output from a serial of classifiers with different numbers of features.\n");

  printf("\n Usage: %s (input1) (input2) (num_subject)",EXEC_NAME);
  printf("\n Usage: %s [-u/h/v]\n",EXEC_NAME);
  
  printf("\n Required arguments:");
  printf("\n   input1        : first set of classification scores to be summed");
  printf("\n   input2        : second set of classification scores to be summed (this file will be overwritten by the output!)");
  printf("\n   num_subject   : number of scores to read in from input files\n");
  
  printf("\n Optional arguments:\n");
  printf("\n   [-u      --usage]     Display this message");
  printf("\n   [-h       --help]     Display this message");
  printf("\n   [-v    --version]     Display version information\n");
  
  printf("\n More information:");
  printf("\n   https://www.rad.upenn.edu/sbia/software/");
  printf("\n   sbia-software@uphs.upenn.edu");
  printf("\n\n");
}

int main(int argc, char *argv[])
{

  static struct option long_options[] =
  {
    {"usage",       no_argument,            0, 'u'},
    {"help",        no_argument,            0, 'h'},
    {"version",     no_argument,            0, 'v'},
  };

  int c, option_index = 0;

  if(argc!=4){
    while ( (c = getopt_long (argc, argv, "uhv",
                long_options,&option_index)) != -1){
      switch (c)
      {
        case 'v':
          version();
          return 0;

        case 'u':
          usage();
          return 0;

        case 'h':
          usage();
          return 0;

        case '?':
          /* getopt_long already printed an error message. */
          break;

        default:
          return 1;
      }
    }
    usage();
    exit(1);
  }

  char* input_file1 = argv[1];
  char* input_file2 = argv[2];
  int num_subject   = atoi(argv[3]);

  float *s = new float [num_subject];
  FILE *fp1, *fp2;
  
  if((fp1=fopen(input_file1,"r"))==NULL)
    {
      printf("\n cannot open file %s.\n",input_file1);
      exit(1);
    }
  if((fp2=fopen(input_file2,"r"))==NULL)
    {
      printf("\n cannot open file %s.\n",input_file2);
      exit(1);
    }
  
  float tmp;
  for(int i=0; i<num_subject; i++)
    {
      fscanf(fp1,"%f",&tmp);
      fscanf(fp2,"%f",&s[i]);
      //printf("\n* %f %f",tmp,s[i]);
      s[i] += tmp;
    }
  fclose(fp1);
  fclose(fp2);
  
  if((fp2=fopen(input_file2,"w"))==NULL)
    {
      printf("\n cannot open file %s.\n",input_file2);
      exit(1);
    }
  
  for(int i=0; i<num_subject; i++)
    fprintf(fp2,"%f\n",s[i]);
  fclose(fp2);
  
  delete [] s;
  
  
  return 0;
}
