/*******************************************************

This program calculates mean of classification scores output from a serial of classifiers.

last modified : Oct 6, 2008

yong.fan@ieee.org
kanterae@uphs.upenn.edu

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <getopt.h>

#define EXEC_NAME "COMPARE_average_score"

#ifndef RELEASE_ID
#define RELEASE_ID "0.0_super_alpha"
#endif

#define SVNFILEVER "$Id: COMPARE_average_score.cc 35 2010-09-22 14:41:15Z batmangn@UPHS.PENNHEALTH.PRV $"

#ifndef SVN_REV
#define SVN_REV "NO_SVN" 
#endif


void version(){
  printf("\n\n%s Version information\n",EXEC_NAME);
  printf("  Release          : %s\n", RELEASE_ID);
  printf("  Svn Revision     : %s\n", SVN_REV);
  printf("  Svn File Version : %s\n", SVNFILEVER);
}

void usage(){
  printf("\n This program calculates mean of classification scores output from a serial of classifiers.\n");

  printf("\n Usage: %s (score_file_base_name) (num_score_file) (num_subject) (result_file)",EXEC_NAME);
  printf("\n Usage: %s [-u/h/v]\n",EXEC_NAME);
  
  printf("\n Required arguments:");
  printf("\n   score_file_base_name : The score files output from a serial of classifiers are named as");
  printf("\n   \"base_name\"_0.txt, \"base_name\"_1.txt, ..., \"base_name\"_(n-1), where n is the number of score files");
  printf("\n   num_score_file       : number of score files");
  printf("\n   num_subject          : number of the subjects in each score file");
  printf("\n   result_file          : file name of output\n");
  
  printf("\n Optional arguments:");
  printf("\n   [-u     --usage]        Display this message");
  printf("\n   [-h      --help]        Display this message");
  printf("\n   [-v   --version]        Display version information\n");
  
  printf("\n More information:");
  printf("\n   https://www.rad.upenn.edu/sbia/software/");
  printf("\n   sbia-software@uphs.upenn.edu");
  printf("\n\n");
}

int main(int argc, char *argv[]){

  static struct option long_options[] =
  {
    {"usage",       no_argument,            0, 'u'},
    {"help",        no_argument,            0, 'h'},
    {"version",     no_argument,            0, 'v'},
  };

  int c, option_index = 0;

  if(argc!=5){
    while ( (c = getopt_long (argc, argv, "uhv",
                long_options,&option_index)) != -1){
      switch (c)
      {
        case 'v':
          version();
          return 0;

        case 'u':
          usage();
          return 0;

        case 'h':
          usage();
          return 0;

        case '?':
          /* getopt_long already printed an error message. */
          break;

        default:
          return 1;
      }
    }
    usage();
    exit(1);
  }
  
  char* score_base_name = argv[1];
  int num_score_file    = atoi(argv[2]);
  int num_subj          = atoi(argv[3]);
  char* result_file  = argv[4];

  float *score = new float [num_subj];
  for(int i=0; i<num_subj; i++)
    score[i] = 0;
  
  float tmp;
  
  char filename[1024];
  FILE *fp;
  
  for(int i=0; i<num_score_file; i++){
    sprintf(filename,"%s_%d.txt",score_base_name,i);
    if((fp=fopen(filename,"r"))==NULL){
	    printf("\n can not open file %s.\n",filename);
	    exit(1);
	  }
    for(int j=0; j<num_subj; j++){
  	  fscanf(fp,"%f",&tmp);
	    score[j]+=tmp;
	  }
    fclose(fp);
  }
   
  if((fp=fopen(result_file,"w"))==NULL){
    printf("\n can not open file %s.\n",result_file);
    exit(1);
  }
  for(int i=0; i<num_subj; i++)
    fprintf(fp,"%f\n",score[i]/num_score_file);

  fclose(fp);  
  
  return 0;
}
