/*******************************************************

This program checks the classification performance using different SVM kernel sizes and outputs the best kernel size.

last modified : Oct 6, 2008

yong.fan@ieee.org
kanterae@uphs.upenn.edu

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>

#define EXEC_NAME "COMPARE_build_check"

#ifndef RELEASE_ID
#define RELEASE_ID "0.0_super_alpha"
#endif

#define SVNFILEVER "$Id: COMPARE_build_check.cc 35 2010-09-22 14:41:15Z batmangn@UPHS.PENNHEALTH.PRV $"

#ifndef SVN_REV
#define SVN_REV "NO_SVN" 
#endif


void version(){
  printf("\n\n%s Version information\n",EXEC_NAME);
  printf("  Release          : %s\n", RELEASE_ID);
  printf("  Svn Revision     : %s\n", SVN_REV);
  printf("  Svn File Version : %s\n", SVNFILEVER);
}

void usage(){
  printf("\n This program checks the classification performance using different SVM kernel sizes and outputs the best kernel size.\n");

  printf("\n Usage: %s (rate_base_name) (min_svm_kernel) (max_svm_kernel)",EXEC_NAME);
  printf("\n Usage: %s [-u/h/v]\n",EXEC_NAME);
  
  printf("\n Required arguments:");
  printf("\n   rate_base_name   : prefix of output for each classification kernel (ex. classification_rate)");
  printf("\n   min_svm_kernel   : min std value for Gaussian kernel in SVM (this value is multiplied by 100)");
  printf("\n   max_svm_kernel   : max std value for Gaussian kernel in SVM (this value is multiplied by 100)\n");
  
  printf("\n Optional arguments:");
  printf("\n   [-u --usage]         Display this message");
  printf("\n   [-h --help]          Display this message");
  printf("\n   [-v --version]       Display version information\n");
  
  printf("\n More information:");
  printf("\n   https://www.rad.upenn.edu/sbia/software/");
  printf("\n   sbia-software@uphs.upenn.edu");
  printf("\n\n");
}

int main(int argc, char *argv[])
{

  static struct option long_options[] =
  {
    {"usage",       no_argument,            0, 'u'},
    {"help",        no_argument,            0, 'h'},
    {"version",     no_argument,            0, 'v'},
  };

  int c, option_index = 0;

  if(argc!=4){
    while ( (c = getopt_long (argc, argv, "uhv",
                long_options,&option_index)) != -1){
      switch (c)
      {
        case 'v':
          version();
          return 0;

        case 'u':
          usage();
          return 0;

        case 'h':
          usage();
          return 0;

        case '?':
          /* getopt_long already printed an error message. */
          break;

        default:
          return 1;
      }
    }
    usage();
    exit(1);
  }

  char *base_name = argv[1];
  argc--;
  argv++;
  int  start_id   = atoi(argv[1]);
  argc--;
  argv++;
  int  end_id     = atoi(argv[1]);
  argc--;
  argv++;

  int num = (end_id-start_id)/100+1;
  FILE *fp;
  if(num==1)
    {
      if((fp=fopen("COMPARE_svm_kernel_size.bin","w"))==NULL)
	{
	  printf("\n cannot open file COMPARE_svm_kernel_size.bin .\n");
	  exit(1);
	}
      fprintf(fp,"%d",start_id/100);
      fclose(fp);
    }
  else
    {
      char fname[10240];
      char stmp[10240];
      float *rate =  new float [num];
      for(int i=0; i<num; i++)
	{
	  sprintf(fname,"%s_%d.bin",base_name,start_id+i*100);
	  if((fp=fopen(fname,"r"))==NULL)
	    {
	      printf("\n cannot open file %s.\n",fname);
	      exit(1);
	    }
	  fscanf(fp,"%s",stmp);
	  fscanf(fp,"%s",stmp);
	  fscanf(fp,"%s",stmp);
	  fscanf(fp,"%s",stmp); 
	  fscanf(fp,"%s",stmp);
	  fscanf(fp,"%f",&rate[i]);
	  fclose(fp);
	}
      int id = 0;
      float max_rate = rate[0];
      for(int i=1; i<num; i++)
	{
	  if(rate[i]>=max_rate)
	    {
	      max_rate = rate[i];
	      id = i;
	    }
	}
      if((fp=fopen("COMPARE_svm_kernel_size.bin","w"))==NULL)
	{
	  printf("\n cannot open file COMPARE_svm_kernel_size.bin .\n");
	  exit(1);
	}
      fprintf(fp,"%d",start_id/100+id);
      fclose(fp);
      delete [] rate;
    }
  
  return 0;
}
